/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.services.ModelBuilderRequest;
import org.apache.maven.api.services.ModelBuilderResult;
import org.apache.maven.api.services.ModelProblem;
import org.apache.maven.api.services.ModelSource;
import org.apache.maven.api.services.ProblemCollector;

class DefaultModelBuilderResult
implements ModelBuilderResult {
    private ModelBuilderRequest request;
    private ModelSource source;
    private Model fileModel;
    private Model rawModel;
    private Model parentModel;
    private Model effectiveModel;
    private List<Profile> activePomProfiles;
    private List<Profile> activeExternalProfiles;
    private final ProblemCollector<ModelProblem> problemCollector;
    private final List<DefaultModelBuilderResult> children = new ArrayList<DefaultModelBuilderResult>();

    DefaultModelBuilderResult(ModelBuilderRequest request, ProblemCollector<ModelProblem> problemCollector) {
        this.request = request;
        this.problemCollector = problemCollector;
    }

    public ModelBuilderRequest getRequest() {
        return this.request;
    }

    public ModelSource getSource() {
        return this.source;
    }

    public void setSource(ModelSource source) {
        this.source = source;
    }

    public Model getFileModel() {
        return this.fileModel;
    }

    public void setFileModel(Model fileModel) {
        this.fileModel = fileModel;
    }

    public Model getRawModel() {
        return this.rawModel;
    }

    public void setRawModel(Model rawModel) {
        this.rawModel = rawModel;
    }

    public Model getParentModel() {
        return this.parentModel;
    }

    public void setParentModel(Model parentModel) {
        this.parentModel = parentModel;
    }

    public Model getEffectiveModel() {
        return this.effectiveModel;
    }

    public void setEffectiveModel(Model model) {
        this.effectiveModel = model;
    }

    public List<Profile> getActivePomProfiles() {
        return this.activePomProfiles;
    }

    public void setActivePomProfiles(List<Profile> activeProfiles) {
        this.activePomProfiles = activeProfiles;
    }

    public List<Profile> getActiveExternalProfiles() {
        return this.activeExternalProfiles;
    }

    public void setActiveExternalProfiles(List<Profile> activeProfiles) {
        this.activeExternalProfiles = activeProfiles;
    }

    public ProblemCollector<ModelProblem> getProblemCollector() {
        return this.problemCollector;
    }

    public List<DefaultModelBuilderResult> getChildren() {
        return this.children;
    }

    public String toString() {
        String modelId = this.effectiveModel != null ? this.effectiveModel.getId() : (this.rawModel != null ? this.rawModel.getId() : (this.fileModel != null ? this.fileModel.getId() : null));
        if (this.problemCollector.hasWarningProblems()) {
            int totalProblems = this.problemCollector.totalProblemsReported();
            StringBuilder sb = new StringBuilder();
            sb.append(totalProblems).append(totalProblems == 1 ? " problem was " : " problems were encountered while building the effective model");
            if (modelId != null && !modelId.isEmpty()) {
                sb.append(" for ");
                sb.append(modelId);
            }
            for (ModelProblem problem : this.problemCollector.problems().toList()) {
                sb.append(System.lineSeparator());
                sb.append("    - [");
                sb.append(problem.getSeverity());
                sb.append("] ");
                if (problem.getMessage() != null && !problem.getMessage().isEmpty()) {
                    sb.append(problem.getMessage());
                } else if (problem.getException() != null) {
                    sb.append(problem.getException().toString());
                }
                String[] stringArray = new String[4];
                stringArray[0] = problem.getModelId().equals(modelId) ? problem.getModelId() : "";
                stringArray[1] = problem.getModelId().equals(modelId) ? problem.getSource() : "";
                stringArray[2] = problem.getLineNumber() > 0 ? "line " + problem.getLineNumber() : "";
                String string = stringArray[3] = problem.getColumnNumber() > 0 ? "column " + problem.getColumnNumber() : "";
                String loc = Stream.of(stringArray).filter(s -> !s.isEmpty()).collect(Collectors.joining(", "));
                if (loc.isEmpty()) continue;
                sb.append(" @ ").append(loc);
            }
            return sb.toString();
        }
        return modelId;
    }
}

