/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ext.xerces.impl.dv.xs;

import org.apache.jena.ext.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.jena.ext.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.apache.jena.ext.xerces.impl.dv.xs.SchemaDateTimeException;

public class TimeDV
extends AbstractDateTimeDV {
    @Override
    public Object getActualValue(String content) throws InvalidDatatypeValueException {
        try {
            return this.parse(content);
        }
        catch (Exception ex) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "time"});
        }
    }

    protected AbstractDateTimeDV.DateTimeData parse(String str2) throws SchemaDateTimeException {
        AbstractDateTimeDV.DateTimeData date2 = new AbstractDateTimeDV.DateTimeData(str2, this);
        int len = str2.length();
        date2.year = 2000;
        date2.month = 1;
        date2.day = 15;
        this.getTime(str2, 0, len, date2);
        this.validateDateTime(date2);
        this.saveUnnormalized(date2);
        if (date2.utc != 0 && date2.utc != 90) {
            this.normalize(date2);
            date2.day = 15;
        }
        date2.position = 2;
        return date2;
    }

    @Override
    protected String dateToString(AbstractDateTimeDV.DateTimeData date2) {
        StringBuilder message = new StringBuilder(16);
        this.append(message, date2.hour, 2);
        message.append(':');
        this.append(message, date2.minute, 2);
        message.append(':');
        this.append(message, date2.second);
        this.append(message, (char)date2.utc, 0);
        return message.toString();
    }
}

