/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner;

import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BinaryLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DoubleLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.GenericLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Literal;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LongLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StringLiteral;

public class CastToInt32LiteralVisitor
extends AstVisitor<Integer, Void> {
    @Override
    protected Integer visitLiteral(Literal node, Void context) {
        throw new UnsupportedOperationException("Unhandled literal type: " + node);
    }

    @Override
    protected Integer visitBooleanLiteral(BooleanLiteral node, Void context) {
        return node.getValue() ? 1 : 0;
    }

    @Override
    protected Integer visitLongLiteral(LongLiteral node, Void context) {
        return (int)node.getParsedValue();
    }

    @Override
    protected Integer visitDoubleLiteral(DoubleLiteral node, Void context) {
        return (int)node.getValue();
    }

    @Override
    protected Integer visitStringLiteral(StringLiteral node, Void context) {
        try {
            return Integer.parseInt(node.getValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected Integer visitBinaryLiteral(BinaryLiteral node, Void context) {
        return null;
    }

    @Override
    protected Integer visitGenericLiteral(GenericLiteral node, Void context) {
        try {
            return Integer.parseInt(node.getValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected Integer visitNullLiteral(NullLiteral node, Void context) {
        return null;
    }
}

