/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.apache.polaris.core.admin.model.Catalog;

@ApiModel(description="Request to create a new catalog")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CreateCatalogRequest {
    @NotNull
    @Valid
    private final Catalog catalog;

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="catalog", required=true)
    public Catalog getCatalog() {
        return this.catalog;
    }

    @JsonCreator
    public CreateCatalogRequest(@JsonProperty(value="catalog", required=true) Catalog catalog) {
        this.catalog = catalog;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Catalog catalog) {
        return new Builder(catalog);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateCatalogRequest createCatalogRequest = (CreateCatalogRequest)o;
        return Objects.equals(this.catalog, createCatalogRequest.catalog);
    }

    public int hashCode() {
        return Objects.hash(this.catalog);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateCatalogRequest {\n");
        sb.append("    catalog: ").append(this.toIndentedString(this.catalog)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private Catalog catalog;

        private Builder() {
        }

        private Builder(Catalog catalog) {
            this.catalog = catalog;
        }

        public Builder setCatalog(Catalog catalog) {
            this.catalog = catalog;
            return this;
        }

        public CreateCatalogRequest build() {
            CreateCatalogRequest inst = new CreateCatalogRequest(this.catalog);
            return inst;
        }
    }
}

