/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.variants;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.variants.BasicType;

class VariantUtil {
    private static final int BASIC_TYPE_MASK = 3;
    private static final int BASIC_TYPE_PRIMITIVE = 0;
    private static final int BASIC_TYPE_SHORT_STRING = 1;
    private static final int BASIC_TYPE_OBJECT = 2;
    private static final int BASIC_TYPE_ARRAY = 3;

    private VariantUtil() {
    }

    static int writeBufferAbsolute(ByteBuffer buffer, int offset, ByteBuffer toCopy) {
        int originalPosition = buffer.position();
        buffer.position(offset);
        ByteBuffer copy = toCopy.duplicate();
        buffer.put(copy);
        buffer.position(originalPosition);
        Preconditions.checkArgument((copy.remaining() <= 0 ? 1 : 0) != 0, (Object)"Not fully written");
        return toCopy.remaining();
    }

    static void writeByte(ByteBuffer buffer, int value, int offset) {
        buffer.put(buffer.position() + offset, (byte)(value & 0xFF));
    }

    static void writeLittleEndianUnsigned(ByteBuffer buffer, int value, int offset, int size) {
        int base = buffer.position() + offset;
        switch (size) {
            case 4: {
                buffer.putInt(base, value);
                return;
            }
            case 3: {
                buffer.putShort(base, (short)(value & 0xFFFF));
                buffer.put(base + 2, (byte)(value >> 16 & 0xFF));
                return;
            }
            case 2: {
                buffer.putShort(base, (short)(value & 0xFFFF));
                return;
            }
            case 1: {
                buffer.put(base, (byte)(value & 0xFF));
                return;
            }
        }
        throw new IllegalArgumentException("Invalid size: " + size);
    }

    static byte readLittleEndianInt8(ByteBuffer buffer, int offset) {
        return buffer.get(buffer.position() + offset);
    }

    static short readLittleEndianInt16(ByteBuffer buffer, int offset) {
        return buffer.getShort(buffer.position() + offset);
    }

    static int readByte(ByteBuffer buffer, int offset) {
        return buffer.get(buffer.position() + offset) & 0xFF;
    }

    static int readLittleEndianUnsigned(ByteBuffer buffer, int offset, int size) {
        int base = buffer.position() + offset;
        switch (size) {
            case 4: {
                return buffer.getInt(base);
            }
            case 3: {
                return buffer.getShort(base) & 0xFFFF | (buffer.get(base + 2) & 0xFF) << 16;
            }
            case 2: {
                return buffer.getShort(base) & 0xFFFF;
            }
            case 1: {
                return buffer.get(base) & 0xFF;
            }
        }
        throw new IllegalArgumentException("Invalid size: " + size);
    }

    static int readLittleEndianInt32(ByteBuffer buffer, int offset) {
        return buffer.getInt(buffer.position() + offset);
    }

    static long readLittleEndianInt64(ByteBuffer buffer, int offset) {
        return buffer.getLong(buffer.position() + offset);
    }

    static float readFloat(ByteBuffer buffer, int offset) {
        return buffer.getFloat(buffer.position() + offset);
    }

    static double readDouble(ByteBuffer buffer, int offset) {
        return buffer.getDouble(buffer.position() + offset);
    }

    static ByteBuffer slice(ByteBuffer buffer, int offset, int length) {
        ByteBuffer slice = buffer.duplicate();
        slice.order(ByteOrder.LITTLE_ENDIAN);
        slice.position(buffer.position() + offset);
        slice.limit(buffer.position() + offset + length);
        return slice;
    }

    static String readString(ByteBuffer buffer, int offset, int length) {
        if (buffer.hasArray()) {
            return new String(buffer.array(), buffer.arrayOffset() + buffer.position() + offset, length, StandardCharsets.UTF_8);
        }
        return StandardCharsets.UTF_8.decode(VariantUtil.slice(buffer, offset, length)).toString();
    }

    static <T extends Comparable<T>> int find(int size, T key, Function<Integer, T> resolve) {
        int low = 0;
        int high = size - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Comparable value = (Comparable)resolve.apply(mid);
            int cmp = key.compareTo((Comparable)value);
            if (cmp == 0) {
                return mid;
            }
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return -1;
    }

    static int sizeOf(int maxValue) {
        if (maxValue <= 255) {
            return 1;
        }
        if (maxValue <= 65535) {
            return 2;
        }
        if (maxValue <= 0xFFFFFF) {
            return 3;
        }
        return 4;
    }

    static byte metadataHeader(boolean isSorted, int offsetSize) {
        return (byte)(offsetSize - 1 << 6 | (isSorted ? 16 : 0) | 1);
    }

    static byte primitiveHeader(int primitiveType) {
        return (byte)(primitiveType << 2);
    }

    static byte objectHeader(boolean isLarge, int fieldIdSize, int offsetSize) {
        return (byte)((isLarge ? 64 : 0) | fieldIdSize - 1 << 4 | offsetSize - 1 << 2 | 2);
    }

    static byte arrayHeader(boolean isLarge, int offsetSize) {
        return (byte)((isLarge ? 16 : 0) | offsetSize - 1 << 2 | 3);
    }

    static byte shortStringHeader(int length) {
        return (byte)(length << 2 | 1);
    }

    static BasicType basicType(int header) {
        int basicType = header & 3;
        switch (basicType) {
            case 0: {
                return BasicType.PRIMITIVE;
            }
            case 1: {
                return BasicType.SHORT_STRING;
            }
            case 2: {
                return BasicType.OBJECT;
            }
            case 3: {
                return BasicType.ARRAY;
            }
        }
        throw new UnsupportedOperationException("Unsupported basic type: " + basicType);
    }
}

