/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.persistence.relational.jdbc.models;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.polaris.core.entity.PolarisPrincipalSecrets;
import org.apache.polaris.persistence.relational.jdbc.DatabaseType;
import org.apache.polaris.persistence.relational.jdbc.models.Converter;

public class ModelPrincipalAuthenticationData
implements Converter<PolarisPrincipalSecrets> {
    public static final String TABLE_NAME = "PRINCIPAL_AUTHENTICATION_DATA";
    public static final List<String> ALL_COLUMNS = List.of("principal_id", "principal_client_id", "main_secret_hash", "secondary_secret_hash", "secret_salt");
    private long principalId;
    private String principalClientId;
    private String mainSecretHash;
    private String secondarySecretHash;
    private String secretSalt;

    public long getPrincipalId() {
        return this.principalId;
    }

    public String getPrincipalClientId() {
        return this.principalClientId;
    }

    public String getSecretSalt() {
        return this.secretSalt;
    }

    public String getMainSecretHash() {
        return this.mainSecretHash;
    }

    public String getSecondarySecretHash() {
        return this.secondarySecretHash;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public PolarisPrincipalSecrets fromResultSet(ResultSet rs) throws SQLException {
        ModelPrincipalAuthenticationData modelRecord = ModelPrincipalAuthenticationData.builder().principalId(rs.getObject("principal_id", Long.class)).principalClientId(rs.getObject("principal_client_id", String.class)).mainSecretHash(rs.getObject("main_secret_hash", String.class)).secondarySecretHash(rs.getObject("secondary_secret_hash", String.class)).secretSalt(rs.getObject("secret_salt", String.class)).build();
        return ModelPrincipalAuthenticationData.toPrincipalAuthenticationData(modelRecord);
    }

    @Override
    public Map<String, Object> toMap(DatabaseType databaseType) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("principal_id", this.principalId);
        map.put("principal_client_id", this.principalClientId);
        map.put("main_secret_hash", this.mainSecretHash);
        map.put("secondary_secret_hash", this.secondarySecretHash);
        map.put("secret_salt", this.secretSalt);
        return map;
    }

    public static ModelPrincipalAuthenticationData fromPrincipalAuthenticationData(PolarisPrincipalSecrets record) {
        if (record == null) {
            return null;
        }
        return ModelPrincipalAuthenticationData.builder().principalId(record.getPrincipalId()).principalClientId(record.getPrincipalClientId()).secretSalt(record.getSecretSalt()).mainSecretHash(record.getMainSecretHash()).secondarySecretHash(record.getSecondarySecretHash()).build();
    }

    public static PolarisPrincipalSecrets toPrincipalAuthenticationData(ModelPrincipalAuthenticationData model) {
        if (model == null) {
            return null;
        }
        return new PolarisPrincipalSecrets(model.getPrincipalId(), model.getPrincipalClientId(), null, null, model.getSecretSalt(), model.getMainSecretHash(), model.getSecondarySecretHash());
    }

    public static final class Builder {
        private final ModelPrincipalAuthenticationData principalAuthenticationData = new ModelPrincipalAuthenticationData();

        private Builder() {
        }

        public Builder principalId(long principalId) {
            this.principalAuthenticationData.principalId = principalId;
            return this;
        }

        public Builder principalClientId(String principalClientId) {
            this.principalAuthenticationData.principalClientId = principalClientId;
            return this;
        }

        public Builder secretSalt(String secretSalt) {
            this.principalAuthenticationData.secretSalt = secretSalt;
            return this;
        }

        public Builder mainSecretHash(String mainSecretHash) {
            this.principalAuthenticationData.mainSecretHash = mainSecretHash;
            return this;
        }

        public Builder secondarySecretHash(String secondarySecretHash) {
            this.principalAuthenticationData.secondarySecretHash = secondarySecretHash;
            return this;
        }

        public ModelPrincipalAuthenticationData build() {
            return this.principalAuthenticationData;
        }
    }
}

