/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.core;

import java.util.concurrent.locks.StampedLock;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.raft.jraft.Closure;
import org.apache.ignite3.raft.jraft.FSMCaller;
import org.apache.ignite3.raft.jraft.Lifecycle;
import org.apache.ignite3.raft.jraft.closure.ClosureQueue;
import org.apache.ignite3.raft.jraft.conf.Configuration;
import org.apache.ignite3.raft.jraft.entity.Ballot;
import org.apache.ignite3.raft.jraft.entity.PeerId;
import org.apache.ignite3.raft.jraft.option.BallotBoxOptions;
import org.apache.ignite3.raft.jraft.util.Describer;
import org.apache.ignite3.raft.jraft.util.OnlyForTest;
import org.apache.ignite3.raft.jraft.util.Requires;
import org.apache.ignite3.raft.jraft.util.SegmentList;

public class BallotBox
implements Lifecycle<BallotBoxOptions>,
Describer {
    private static final IgniteLogger LOG = Loggers.forClass(BallotBox.class);
    private FSMCaller waiter;
    private ClosureQueue closureQueue;
    private final StampedLock stampedLock = new StampedLock();
    private long lastCommittedIndex = 0L;
    private long pendingIndex;
    private final SegmentList<Ballot> pendingMetaQueue = new SegmentList(false);

    @OnlyForTest
    long getPendingIndex() {
        return this.pendingIndex;
    }

    @OnlyForTest
    SegmentList<Ballot> getPendingMetaQueue() {
        return this.pendingMetaQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastCommittedIndex() {
        long stamp = this.stampedLock.tryOptimisticRead();
        long optimisticVal = this.lastCommittedIndex;
        if (this.stampedLock.validate(stamp)) {
            return optimisticVal;
        }
        stamp = this.stampedLock.readLock();
        try {
            long l = this.lastCommittedIndex;
            return l;
        }
        finally {
            this.stampedLock.unlockRead(stamp);
        }
    }

    @Override
    public boolean init(BallotBoxOptions opts) {
        if (opts.getWaiter() == null || opts.getClosureQueue() == null) {
            LOG.error("waiter or closure queue is null.", new Object[0]);
            return false;
        }
        this.waiter = opts.getWaiter();
        this.closureQueue = opts.getClosureQueue();
        this.lastCommittedIndex = opts.getLastCommittedIndex();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commitAt(long firstLogIndex, long lastLogIndex, PeerId peer) {
        long stamp = this.stampedLock.writeLock();
        long lastCommittedIndex = 0L;
        try {
            if (this.pendingIndex == 0L) {
                boolean bl = false;
                return bl;
            }
            if (lastLogIndex < this.pendingIndex) {
                boolean bl = true;
                return bl;
            }
            if (lastLogIndex >= this.pendingIndex + (long)this.pendingMetaQueue.size()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            long startAt = Math.max(this.pendingIndex, firstLogIndex);
            Ballot.PosHint hint = new Ballot.PosHint();
            for (long logIndex = startAt; logIndex <= lastLogIndex; ++logIndex) {
                Ballot bl = this.pendingMetaQueue.get((int)(logIndex - this.pendingIndex));
                hint = bl.grant(peer, hint);
                if (!bl.isGranted()) continue;
                lastCommittedIndex = logIndex;
            }
            if (lastCommittedIndex == 0L) {
                boolean bl = true;
                return bl;
            }
            this.pendingMetaQueue.removeFromFirst((int)(lastCommittedIndex - this.pendingIndex) + 1);
            LOG.debug("Committed log fromIndex={}, toIndex={}.", this.pendingIndex, lastCommittedIndex);
            this.pendingIndex = lastCommittedIndex + 1L;
            this.lastCommittedIndex = lastCommittedIndex;
        }
        finally {
            this.stampedLock.unlockWrite(stamp);
        }
        this.waiter.onCommitted(lastCommittedIndex);
        return true;
    }

    public void clearPendingTasks() {
        long stamp = this.stampedLock.writeLock();
        try {
            this.pendingMetaQueue.clear();
            this.pendingIndex = 0L;
            this.closureQueue.clear();
        }
        finally {
            this.stampedLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resetPendingIndex(long newPendingIndex) {
        long stamp = this.stampedLock.writeLock();
        try {
            if (this.pendingIndex != 0L || !this.pendingMetaQueue.isEmpty()) {
                LOG.error("resetPendingIndex fail, pendingIndex={}, pendingMetaQueueSize={}.", this.pendingIndex, this.pendingMetaQueue.size());
                boolean bl = false;
                return bl;
            }
            if (newPendingIndex <= this.lastCommittedIndex) {
                LOG.error("resetPendingIndex fail, newPendingIndex={}, lastCommittedIndex={}.", newPendingIndex, this.lastCommittedIndex);
                boolean bl = false;
                return bl;
            }
            this.pendingIndex = newPendingIndex;
            this.closureQueue.resetFirstIndex(newPendingIndex);
            boolean bl = true;
            return bl;
        }
        finally {
            this.stampedLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean appendPendingTask(Configuration conf, Configuration oldConf, Closure done) {
        Ballot bl = new Ballot();
        bl.init(conf, oldConf);
        long stamp = this.stampedLock.writeLock();
        try {
            if (this.pendingIndex <= 0L) {
                LOG.error("Fail to appendingTask, pendingIndex={}.", this.pendingIndex);
                boolean bl2 = false;
                return bl2;
            }
            this.pendingMetaQueue.add(bl);
            this.closureQueue.appendPendingClosure(done);
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.stampedLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setLastCommittedIndex(long lastCommittedIndex) {
        boolean doUnlock = true;
        long stamp = this.stampedLock.writeLock();
        try {
            if (this.pendingIndex != 0L || !this.pendingMetaQueue.isEmpty()) {
                Requires.requireTrue(lastCommittedIndex < this.pendingIndex, "Node changes to leader, pendingIndex=%d, param lastCommittedIndex=%d", this.pendingIndex, lastCommittedIndex);
                boolean bl = false;
                return bl;
            }
            if (lastCommittedIndex < this.lastCommittedIndex) {
                boolean bl = false;
                return bl;
            }
            if (lastCommittedIndex > this.lastCommittedIndex) {
                this.lastCommittedIndex = lastCommittedIndex;
                this.stampedLock.unlockWrite(stamp);
                doUnlock = false;
                this.waiter.onCommitted(lastCommittedIndex);
            }
        }
        finally {
            if (doUnlock) {
                this.stampedLock.unlockWrite(stamp);
            }
        }
        return true;
    }

    @Override
    public void shutdown() {
        this.clearPendingTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void describe(Describer.Printer out) {
        long _pendingMetaQueueSize;
        long _pendingIndex;
        long _lastCommittedIndex;
        long stamp = this.stampedLock.tryOptimisticRead();
        if (this.stampedLock.validate(stamp)) {
            _lastCommittedIndex = this.lastCommittedIndex;
            _pendingIndex = this.pendingIndex;
            _pendingMetaQueueSize = this.pendingMetaQueue.size();
        } else {
            stamp = this.stampedLock.readLock();
            try {
                _lastCommittedIndex = this.lastCommittedIndex;
                _pendingIndex = this.pendingIndex;
                _pendingMetaQueueSize = this.pendingMetaQueue.size();
            }
            finally {
                this.stampedLock.unlockRead(stamp);
            }
        }
        out.print("  lastCommittedIndex: ").println(_lastCommittedIndex);
        out.print("  pendingIndex: ").println(_pendingIndex);
        out.print("  pendingMetaQueueSize: ").println(_pendingMetaQueueSize);
    }
}

