/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage;

import java.util.UUID;
import org.apache.ignite3.internal.storage.CommitResultStatus;
import org.apache.ignite3.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class CommitResult {
    private static final CommitResult SUCCESS_COMMIT_RESULT = new CommitResult(CommitResultStatus.SUCCESS, null);
    private static final CommitResult NO_WRITE_INTENT_COMMIT_RESULT = new CommitResult(CommitResultStatus.NO_WRITE_INTENT, null);
    private final CommitResultStatus status;
    @Nullable
    private final UUID expectedTxId;

    private CommitResult(CommitResultStatus status, @Nullable UUID expectedTxId) {
        this.status = status;
        this.expectedTxId = expectedTxId;
    }

    public static CommitResult success() {
        return SUCCESS_COMMIT_RESULT;
    }

    public static CommitResult noWriteIntent() {
        return NO_WRITE_INTENT_COMMIT_RESULT;
    }

    public static CommitResult txMismatch(UUID expectedTxId) {
        return new CommitResult(CommitResultStatus.TX_MISMATCH, expectedTxId);
    }

    public CommitResultStatus status() {
        return this.status;
    }

    @Nullable
    public UUID expectedTxId() {
        return this.expectedTxId;
    }

    public String toString() {
        return S.toString(this);
    }
}

