/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.core.call;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.time.temporal.ChronoUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import me.tongfei.progressbar.ProgressBarBuilder;
import me.tongfei.progressbar.ProgressBarStyle;
import org.apache.ignite3.internal.cli.core.call.AsyncCall;
import org.apache.ignite3.internal.cli.core.call.AsyncCallExecutionPipeline;
import org.apache.ignite3.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite3.internal.cli.core.call.CallExecutionPipelineBuilder;
import org.apache.ignite3.internal.cli.core.call.CallInput;
import org.apache.ignite3.internal.cli.core.call.ProgressTracker;
import org.apache.ignite3.internal.cli.core.decorator.Decorator;
import org.apache.ignite3.internal.cli.core.decorator.TerminalOutput;
import org.apache.ignite3.internal.cli.core.exception.ExceptionHandler;
import org.apache.ignite3.internal.cli.core.exception.ExceptionHandlers;
import org.apache.ignite3.internal.cli.core.exception.handler.DefaultExceptionHandlers;

public class AsyncCallExecutionPipelineBuilder<I extends CallInput, T>
implements CallExecutionPipelineBuilder<I, T> {
    private final Function<ProgressTracker, AsyncCall<I, T>> callFactory;
    private final ProgressBarBuilder progressBarBuilder = new ProgressBarBuilder().setStyle(ProgressBarStyle.UNICODE_BLOCK).continuousUpdate().setSpeedUnit(ChronoUnit.SECONDS).setInitialMax(100L).hideETA().setTaskName("").showSpeed();
    private final ExceptionHandlers exceptionHandlers = new DefaultExceptionHandlers();
    private Supplier<I> inputProvider;
    private PrintWriter output = AsyncCallExecutionPipelineBuilder.wrapOutputStream(System.out);
    private PrintWriter errOutput = AsyncCallExecutionPipelineBuilder.wrapOutputStream(System.err);
    private Decorator<T, TerminalOutput> decorator;
    private boolean[] verbose;

    AsyncCallExecutionPipelineBuilder(Function<ProgressTracker, AsyncCall<I, T>> callFactory) {
        this.callFactory = callFactory;
    }

    private static PrintWriter wrapOutputStream(OutputStream output) {
        return new PrintWriter(output, true, AsyncCallExecutionPipelineBuilder.getStdoutEncoding());
    }

    private static Charset getStdoutEncoding() {
        String encoding = System.getProperty("sun.stdout.encoding");
        return encoding != null ? Charset.forName(encoding) : Charset.defaultCharset();
    }

    public AsyncCallExecutionPipelineBuilder<I, T> inputProvider(Supplier<I> inputProvider) {
        this.inputProvider = inputProvider;
        return this;
    }

    @Override
    public AsyncCallExecutionPipelineBuilder<I, T> output(PrintWriter output) {
        this.output = output;
        return this;
    }

    public AsyncCallExecutionPipelineBuilder<I, T> output(OutputStream output) {
        return this.output(AsyncCallExecutionPipelineBuilder.wrapOutputStream(output));
    }

    @Override
    public AsyncCallExecutionPipelineBuilder<I, T> errOutput(PrintWriter errOutput) {
        this.errOutput = errOutput;
        return this;
    }

    public AsyncCallExecutionPipelineBuilder<I, T> errOutput(OutputStream output) {
        return this.errOutput(AsyncCallExecutionPipelineBuilder.wrapOutputStream(output));
    }

    public AsyncCallExecutionPipelineBuilder<I, T> exceptionHandler(ExceptionHandler<?> exceptionHandler) {
        this.exceptionHandlers.addExceptionHandler(exceptionHandler);
        return this;
    }

    public AsyncCallExecutionPipelineBuilder<I, T> exceptionHandlers(ExceptionHandlers exceptionHandlers) {
        this.exceptionHandlers.addExceptionHandlers(exceptionHandlers);
        return this;
    }

    public AsyncCallExecutionPipelineBuilder<I, T> decorator(Decorator<T, TerminalOutput> decorator) {
        this.decorator = decorator;
        return this;
    }

    @Override
    public AsyncCallExecutionPipelineBuilder<I, T> verbose(boolean[] verbose) {
        this.verbose = verbose;
        return this;
    }

    public AsyncCallExecutionPipelineBuilder<I, T> name(String name) {
        this.progressBarBuilder.setTaskName(name);
        return this;
    }

    @Override
    public CallExecutionPipeline<I, T> build() {
        return new AsyncCallExecutionPipeline<I, T>(this.callFactory, this.progressBarBuilder, this.output, this.errOutput, this.exceptionHandlers, this.decorator, this.inputProvider, this.verbose);
    }
}

