/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.sql.SQLException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.query.IgniteQueryErrorCode;
import org.jetbrains.annotations.Nullable;

public class IgniteSQLException
extends IgniteException {
    private static final long serialVersionUID = 0L;
    private final String sqlState;
    private final int statusCode;

    public IgniteSQLException(String msg) {
        this(msg, 1, (String)null);
    }

    public IgniteSQLException(SQLException cause) {
        super(cause);
        this.sqlState = cause.getSQLState();
        this.statusCode = 1;
    }

    public IgniteSQLException(String msg, @Nullable Throwable cause) {
        this(msg, 1, cause);
    }

    public IgniteSQLException(String msg, int statusCode, @Nullable Throwable cause) {
        this(msg, statusCode, IgniteQueryErrorCode.codeToSqlState(statusCode), cause);
    }

    public IgniteSQLException(String msg, int statusCode) {
        this(msg, statusCode, IgniteQueryErrorCode.codeToSqlState(statusCode));
    }

    public IgniteSQLException(String msg, int statusCode, String sqlState) {
        this(msg, statusCode, sqlState, null);
    }

    private IgniteSQLException(String msg, int statusCode, String sqlState, @Nullable Throwable cause) {
        super(msg, cause);
        this.sqlState = sqlState;
        this.statusCode = statusCode;
    }

    public int statusCode() {
        return this.statusCode;
    }

    public String sqlState() {
        return this.sqlState;
    }

    public SQLException toJdbcException() {
        return new SQLException(this.getMessage(), this.sqlState, this.statusCode, this);
    }
}

