/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.configuration.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.ignite.shaded.org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.shaded.org.apache.ignite.configuration.validation.Validator;

class ValidatorChecker {
    private static final Pattern CONFIGURATION_SCHEMA_PATTERN = Pattern.compile("ConfigurationSchema$");

    ValidatorChecker() {
    }

    static boolean canValidate(Validator<?, ?> validator, Class<? extends Annotation> annotationType, Class<?> schemaFieldType, boolean namedList) {
        Type[] genericTypeParameters = ValidatorChecker.genericTypeParameters(validator);
        if (genericTypeParameters[0] != annotationType) {
            return false;
        }
        Type viewType = genericTypeParameters[1];
        if (viewType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)viewType;
            assert (parameterizedType.getRawType() == NamedListView.class) : "Unsupported value type in validator " + String.valueOf(validator.getClass());
            if (!namedList) {
                return false;
            }
            Type namedListElementType = parameterizedType.getActualTypeArguments()[0];
            if (namedListElementType instanceof WildcardType) {
                return true;
            }
            assert (namedListElementType instanceof Class) : "Unsupported value type in validator " + String.valueOf(validator.getClass());
            Class namedListElementClass = (Class)namedListElementType;
            return ValidatorChecker.canValidateConfigValue(schemaFieldType, namedListElementClass);
        }
        if (namedList) {
            return false;
        }
        assert (viewType instanceof Class) : "Unsupported value type in validator " + String.valueOf(validator.getClass());
        if (schemaFieldType.getName().endsWith("ConfigurationSchema")) {
            return ValidatorChecker.canValidateConfigValue(schemaFieldType, (Class)viewType);
        }
        return ValidatorChecker.canValidateValue(schemaFieldType, (Class)viewType);
    }

    private static Type[] genericTypeParameters(Validator<?, ?> validator) {
        Class<?> theClass = validator.getClass();
        while (!List.of(theClass.getInterfaces()).contains(Validator.class)) {
            theClass = theClass.getSuperclass();
        }
        Type genericInterface = Arrays.stream(theClass.getGenericInterfaces()).filter(i -> i instanceof ParameterizedType && ((ParameterizedType)i).getRawType() == Validator.class).findAny().orElse(null);
        assert (genericInterface != null) : validator;
        ParameterizedType parameterizedInterface = (ParameterizedType)genericInterface;
        return parameterizedInterface.getActualTypeArguments();
    }

    private static boolean canValidateValue(Class<?> schemaFieldType, Class<?> viewClass) {
        if (schemaFieldType.isPrimitive()) {
            switch (schemaFieldType.getSimpleName()) {
                case "boolean": {
                    schemaFieldType = Boolean.class;
                    break;
                }
                case "byte": {
                    schemaFieldType = Byte.class;
                    break;
                }
                case "short": {
                    schemaFieldType = Short.class;
                    break;
                }
                case "int": {
                    schemaFieldType = Integer.class;
                    break;
                }
                case "long": {
                    schemaFieldType = Long.class;
                    break;
                }
                case "float": {
                    schemaFieldType = Float.class;
                    break;
                }
                case "double": {
                    schemaFieldType = Double.class;
                    break;
                }
                case "char": {
                    schemaFieldType = Character.class;
                    break;
                }
            }
        }
        return viewClass.isAssignableFrom(schemaFieldType);
    }

    private static boolean canValidateConfigValue(Class<?> schemaFieldType, Class<?> viewClass) {
        if (viewClass == Object.class) {
            return true;
        }
        String viewClassName = viewClass.getName();
        assert (viewClassName.endsWith("View")) : viewClassName;
        while (schemaFieldType.getSimpleName().endsWith("ConfigurationSchema")) {
            String schemaFieldViewTypeName = schemaFieldType.getPackageName() + "." + CONFIGURATION_SCHEMA_PATTERN.matcher(schemaFieldType.getSimpleName()).replaceAll("View");
            if (schemaFieldViewTypeName.equals(viewClassName)) {
                return true;
            }
            schemaFieldType = schemaFieldType.getSuperclass();
        }
        return false;
    }
}

