/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import jakarta.servlet.jsp.JspException;
import java.beans.PropertyEditor;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.tags.HtmlEscapingAwareTag;
import org.springframework.web.servlet.tags.form.TagWriter;
import org.springframework.web.servlet.tags.form.ValueFormatter;

public abstract class AbstractFormTag
extends HtmlEscapingAwareTag {
    @Nullable
    protected Object evaluate(String attributeName, @Nullable Object value) throws JspException {
        return value;
    }

    protected final void writeOptionalAttribute(TagWriter tagWriter, String attributeName, @Nullable String value) throws JspException {
        if (value != null) {
            tagWriter.writeOptionalAttributeValue(attributeName, this.getDisplayString(this.evaluate(attributeName, value)));
        }
    }

    protected TagWriter createTagWriter() {
        return new TagWriter(this.pageContext);
    }

    @Override
    protected final int doStartTagInternal() throws Exception {
        return this.writeTagContent(this.createTagWriter());
    }

    protected String getDisplayString(@Nullable Object value) {
        String displayString = ValueFormatter.getDisplayString(value, false);
        return this.isHtmlEscape() ? this.htmlEscape(displayString) : displayString;
    }

    protected String getDisplayString(@Nullable Object value, @Nullable PropertyEditor propertyEditor) {
        String displayString = ValueFormatter.getDisplayString(value, propertyEditor, false);
        return this.isHtmlEscape() ? this.htmlEscape(displayString) : displayString;
    }

    @Override
    protected boolean isDefaultHtmlEscape() {
        Boolean defaultHtmlEscape = this.getRequestContext().getDefaultHtmlEscape();
        return defaultHtmlEscape == null || defaultHtmlEscape != false;
    }

    protected abstract int writeTagContent(TagWriter var1) throws JspException;
}

