/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.flex.utils.DAByteArrayOutputStream;
import org.apache.flex.utils.Trace;

public final class FileUtils {
    private static HashMap<String, String> filemap = null;
    private static boolean checkCase = false;

    public static String canonicalPath(File file) {
        return FileUtils.canonicalFile(file).getPath();
    }

    public static File canonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file.getAbsoluteFile();
        }
    }

    public static synchronized String getTheRealPathBecauseCanonicalizeDoesNotFixCase(File f) {
        if (filemap == null) {
            filemap = new HashMap();
            checkCase = System.getProperty("os.name").toLowerCase().startsWith("windows");
        }
        String path = FileUtils.canonicalPath(f);
        if (!checkCase || !f.exists()) {
            return path;
        }
        if (filemap.containsKey(path)) {
            return filemap.get(path);
        }
        String file = f.getName();
        File canonfile = new File(path);
        File dir = new File(canonfile.getParent());
        String[] ss = dir.list();
        if (ss != null) {
            int i;
            int n = ss.length;
            File[] files = new File[n];
            for (i = 0; i < n; ++i) {
                files[i] = new File(canonfile.getPath(), ss[i]);
            }
            for (i = 0; i < files.length; ++i) {
                if (!files[i].getName().equalsIgnoreCase(file)) continue;
                filemap.put(path, files[i].getAbsolutePath());
                return files[i].getAbsolutePath();
            }
        }
        return path;
    }

    public static URI toURI(File f) throws URISyntaxException {
        String s = f.getAbsolutePath();
        if (File.separatorChar != '/') {
            s = s.replace(File.separatorChar, '/');
        }
        if (!s.startsWith("/")) {
            s = "/" + s;
        }
        if (!s.endsWith("/") && f.isDirectory()) {
            s = s + "/";
        }
        return new URI("file", s, null);
    }

    public static String addPathComponents(String p1, String p2, char sepchar) {
        int r2;
        int r1;
        if (p1 == null) {
            p1 = "";
        }
        if (p2 == null) {
            p2 = "";
        }
        for (r1 = p1.length() - 1; r1 >= 0 && p1.charAt(r1) == sepchar; --r1) {
        }
        for (r2 = 0; r2 < p2.length() && p2.charAt(r2) == sepchar; ++r2) {
        }
        String left = p1.substring(0, r1 + 1);
        String right = p2.substring(r2);
        String sep = "";
        if (left.length() > 0 && right.length() > 0) {
            sep = sep + sepchar;
        }
        return left + sep + right;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream in) {
        DAByteArrayOutputStream baos = new DAByteArrayOutputStream(8192);
        byte[] buffer = new byte[8192];
        int num = 0;
        BufferedInputStream inputStream = new BufferedInputStream(in);
        try {
            while ((num = ((InputStream)inputStream).read(buffer)) != -1) {
                baos.write(buffer, 0, num);
            }
            byte[] byArray = baos.getDirectByteArray();
            return byArray;
        }
        catch (IOException ex) {
            if (Trace.error) {
                ex.printStackTrace();
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)baos);
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return new byte[0];
    }

    public static boolean isAbsolute(File f) {
        boolean absolute;
        block2: {
            absolute = false;
            try {
                absolute = f.isAbsolute();
            }
            catch (SecurityException se) {
                if (!Trace.pathResolver) break block2;
                Trace.trace(se.getMessage());
            }
        }
        return absolute;
    }
}

