/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.swf.tags;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Set;
import org.apache.flex.swf.TagType;
import org.apache.flex.swf.tags.ICharacterTag;
import org.apache.flex.swf.tags.IManagedTag;
import org.apache.flex.swf.tags.Tag;

public final class SymbolClassTag
extends Tag
implements IManagedTag {
    private final BiMap<String, ICharacterTag> exports = HashBiMap.create();

    public SymbolClassTag() {
        super(TagType.SymbolClass);
    }

    @Override
    public String description() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(String.format("total=%d; ", this.size()));
        for (String name : this.exports.keySet()) {
            ICharacterTag tag = (ICharacterTag)this.exports.get((Object)name);
            buffer.append(String.format("(%s:%s#%d) ", new Object[]{name, tag.getTagType(), tag.getCharacterID()}));
        }
        return buffer.toString();
    }

    public Set<String> getSymbolNames() {
        return this.exports.keySet();
    }

    public ICharacterTag getSymbol(String name) {
        return (ICharacterTag)this.exports.get((Object)name);
    }

    public void addSymbol(ICharacterTag characterTag, String name) {
        assert (characterTag != null);
        assert (name != null);
        assert (!"".equals(name));
        this.removeSymbol(characterTag);
        this.exports.forcePut((Object)name, (Object)characterTag);
    }

    public final String getSymbolName(ICharacterTag characterTag) {
        return (String)this.exports.inverse().get((Object)characterTag);
    }

    public void removeSymbol(ICharacterTag characterTag) {
        this.exports.inverse().remove((Object)characterTag);
    }

    public void removeSymbol(String name) {
        this.exports.remove((Object)name);
    }

    public int size() {
        return this.exports.size();
    }
}

