/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.problems;

import org.apache.flex.compiler.clients.problems.ProblemFormatter;
import org.apache.flex.compiler.common.ISourceLocation;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.internal.parsing.as.ASToken;
import org.apache.flex.compiler.problems.CompilerProblemClassification;
import org.apache.flex.compiler.problems.CompilerProblemSeverity;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.problems.annotations.DefaultSeverity;
import org.apache.flex.compiler.problems.annotations.ProblemClassification;
import org.apache.flex.utils.FilenameNormalization;

@ProblemClassification(value=CompilerProblemClassification.DEFAULT)
@DefaultSeverity(value=CompilerProblemSeverity.ERROR)
public abstract class CompilerProblem
implements ICompilerProblem {
    private final String sourcePath;
    private final int start;
    private final int end;
    private final int line;
    private final int column;
    private final int endLine;
    private final int endColumn;

    public CompilerProblem(String sourcePath, int start, int end, int line, int column, int endLine, int endColumn, boolean normalizeFilePath) {
        if (sourcePath != null && normalizeFilePath) {
            sourcePath = FilenameNormalization.normalize(sourcePath);
        }
        this.sourcePath = sourcePath;
        this.start = start;
        this.end = end;
        this.line = line;
        this.column = column;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public CompilerProblem(String sourcePath, int start, int end, int line, int column, boolean normalizeFilePath) {
        this(sourcePath, start, end, line, column, line, column, normalizeFilePath);
    }

    public CompilerProblem(String sourcePath, int start, int end, int line, int column) {
        this(sourcePath, start, end, line, column, true);
    }

    public CompilerProblem(String sourcePath, int start, int end, int line, int column, int endLine, int endColumn) {
        this(sourcePath, start, end, line, column, endLine, endColumn, true);
    }

    public CompilerProblem(String sourcePath) {
        this(sourcePath, -1, -1, -1, -1, true);
    }

    public CompilerProblem() {
        this(null, -1, -1, -1, -1, true);
    }

    public CompilerProblem(ISourceLocation site) {
        this(site.getSourcePath(), site.getStart(), site.getEnd(), site.getLine(), site.getColumn(), site.getEndLine(), site.getEndColumn());
    }

    public CompilerProblem(IDefinition site) {
        this(site.getSourcePath(), site.getNameStart(), site.getNameEnd(), site.getNameLine(), site.getNameColumn(), site.getNameLine(), site.getNameColumn() + site.getNameEnd() - site.getNameStart());
    }

    public CompilerProblem(ASToken site) {
        this(site.getSourcePath(), site.getLocalStart(), site.getLocalEnd(), site.getLine(), site.getColumn(), site.getEndLine(), site.getEndColumn());
    }

    @Override
    public String getID() {
        return this.getClass().getName();
    }

    @Override
    public String getSourcePath() {
        return this.sourcePath;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    @Override
    public int getEndColumn() {
        return this.endColumn;
    }

    @Override
    public int getAbsoluteStart() {
        return this.start;
    }

    @Override
    public int getAbsoluteEnd() {
        return this.end;
    }

    public String toString() {
        return ProblemFormatter.DEFAULT_FORMATTER.format(this);
    }
}

