/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.targets;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flex.abc.ABCLinker;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.references.IResolvedQualifiersReference;
import org.apache.flex.compiler.definitions.references.ReferenceFactory;
import org.apache.flex.compiler.internal.config.FrameInfo;
import org.apache.flex.compiler.internal.definitions.ClassDefinition;
import org.apache.flex.compiler.internal.projects.CompilerProject;
import org.apache.flex.compiler.internal.targets.ITargetAttributes;
import org.apache.flex.compiler.internal.targets.NilTargetAttributes;
import org.apache.flex.compiler.internal.targets.SWFTarget;
import org.apache.flex.compiler.problems.FileNotFoundProblem;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.problems.ImproperlyConfiguredTargetProblem;
import org.apache.flex.compiler.problems.UnableToFindRootClassDefinitionProblem;
import org.apache.flex.compiler.targets.ITargetProgressMonitor;
import org.apache.flex.compiler.targets.ITargetSettings;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IFileNode;
import org.apache.flex.compiler.units.ICompilationUnit;
import org.apache.flex.compiler.units.requests.IRequest;
import org.apache.flex.compiler.units.requests.ISyntaxTreeRequestResult;
import org.apache.flex.swf.ISWF;
import org.apache.flex.swf.SWFFrame;
import org.apache.flex.swf.tags.DoABCTag;

public class AppSWFTarget
extends SWFTarget {
    private static final SWFTarget.FramesInformation NO_EXPLICIT_FRAMES = new SWFTarget.FramesInformation(Collections.<SWFTarget.SWFFrameInfo>emptyList());
    private final Set<ICompilationUnit> additionalRootedCompilationUnits;
    private SWFTarget.FramesInformation swfFrameInfosForExplicitFrames;
    private ClassDefinition rootClassDefinition;

    public AppSWFTarget(CompilerProject project, ITargetSettings targetSettings, ITargetProgressMonitor progressMonitor) {
        this(project, targetSettings, progressMonitor, Collections.emptySet());
    }

    public AppSWFTarget(CompilerProject project, ITargetSettings targetSettings, ITargetProgressMonitor progressMonitor, Set<ICompilationUnit> additionalRootedCompilationUnits) {
        super(project, targetSettings, progressMonitor);
        assert (additionalRootedCompilationUnits != null);
        this.additionalRootedCompilationUnits = additionalRootedCompilationUnits;
    }

    @Override
    protected Iterable<ICompilerProblem> computeFatalProblems() throws InterruptedException {
        Iterable<ICompilerProblem> fatalProblemsFromSuper = super.computeFatalProblems();
        if (!Iterables.isEmpty(fatalProblemsFromSuper)) {
            return fatalProblemsFromSuper;
        }
        IResolvedQualifiersReference rootClassRef = this.getRootClassReference();
        if (rootClassRef == null) {
            return ImmutableList.of((Object)new ImproperlyConfiguredTargetProblem());
        }
        String rootClassFileName = this.targetSettings.getRootSourceFileName();
        if (rootClassFileName == null) {
            return ImmutableList.of((Object)new ImproperlyConfiguredTargetProblem());
        }
        Collection<ICompilationUnit> rootClassCompilationUnits = this.project.getCompilationUnits(rootClassFileName);
        assert (rootClassCompilationUnits.isEmpty() || rootClassCompilationUnits.size() == 1);
        if (rootClassCompilationUnits.isEmpty()) {
            return ImmutableList.of((Object)new FileNotFoundProblem(rootClassFileName));
        }
        assert (Iterables.getOnlyElement(rootClassCompilationUnits) != null) : "The build should have been aborted before this point if there is no root class compilation unit.";
        IDefinition rootClassDefinition = rootClassRef.resolve(this.project);
        if (rootClassDefinition == null) {
            return ImmutableList.of((Object)new UnableToFindRootClassDefinitionProblem(this.targetSettings.getRootClassName()));
        }
        return ImmutableList.of();
    }

    private SWFTarget.FramesInformation computeExplicitFramesInformation() {
        List<FrameInfo> explicitFrames = this.targetSettings.getFrameLabels();
        if (explicitFrames.isEmpty()) {
            return NO_EXPLICIT_FRAMES;
        }
        ArrayList<SWFTarget.SWFFrameInfo> frames = new ArrayList<SWFTarget.SWFFrameInfo>(explicitFrames.size());
        for (FrameInfo frameInfo : explicitFrames) {
            ImmutableList.Builder problems = ImmutableList.builder();
            List<String> classes = frameInfo.getFrameClasses();
            ArrayList<ClassDefinition> resolvedClasses = new ArrayList<ClassDefinition>(classes.size());
            HashSet<ICompilationUnit> frameCompilationUnits = new HashSet<ICompilationUnit>(classes.size());
            for (String frameClass : classes) {
                IResolvedQualifiersReference ref = ReferenceFactory.packageQualifiedReference(this.project.getWorkspace(), frameClass);
                IDefinition def = ref.resolve(this.project);
                if (!(def instanceof ClassDefinition)) continue;
                resolvedClasses.add((ClassDefinition)def);
                ICompilationUnit defCU = this.project.getScope().getCompilationUnitForDefinition(def);
                assert (defCU != null) : "could not resolve def to CU";
                frameCompilationUnits.add(defCU);
            }
            frames.add(new SWFTarget.SWFFrameInfo(frameInfo.getLabel(), true, frameCompilationUnits, (Iterable<ICompilerProblem>)problems.build()));
        }
        return new SWFTarget.FramesInformation(frames);
    }

    protected final SWFTarget.FramesInformation getExplicitFramesInformation() {
        if (this.swfFrameInfosForExplicitFrames != null) {
            return this.swfFrameInfosForExplicitFrames;
        }
        this.swfFrameInfosForExplicitFrames = this.computeExplicitFramesInformation();
        return this.swfFrameInfosForExplicitFrames;
    }

    @Override
    protected ITargetAttributes computeTargetAttributes() throws InterruptedException {
        ICompilationUnit mainUnit = this.getRootClassCompilationUnit();
        IRequest<ISyntaxTreeRequestResult, ICompilationUnit> request = mainUnit.getSyntaxTreeRequest();
        ISyntaxTreeRequestResult result = request.get();
        IASNode root = result.getAST();
        if (!(root instanceof IFileNode)) {
            return NilTargetAttributes.INSTANCE;
        }
        ITargetAttributes nodeTargetAttributes = ((IFileNode)root).getTargetAttributes(this.project);
        if (nodeTargetAttributes == null) {
            return NilTargetAttributes.INSTANCE;
        }
        return nodeTargetAttributes;
    }

    private SWFTarget.SWFFrameInfo createMainFrameInfo() throws InterruptedException {
        ImmutableSet.Builder compilationUnits = ImmutableSet.builder();
        ICompilationUnit rootCU = this.getRootClassCompilationUnit();
        compilationUnits.add((Object)rootCU);
        Set<ICompilationUnit> includesCompilationUnits = this.getIncludesCompilationUnits();
        compilationUnits.addAll(includesCompilationUnits);
        Collection<ICompilationUnit> includeLibrariesCompilationUnits = this.getIncludeLibrariesCompilationUnits();
        compilationUnits.addAll(includeLibrariesCompilationUnits);
        compilationUnits.addAll(this.additionalRootedCompilationUnits);
        Collection<ICompilerProblem> externallyVisibleDefinitionProblems = rootCU.getFileScopeRequest().get().checkExternallyVisibleDefinitions(this.targetSettings.getRootClassName());
        SWFTarget.SWFFrameInfo mainFrameInfo = new SWFTarget.SWFFrameInfo((Set<ICompilationUnit>)compilationUnits.build(), externallyVisibleDefinitionProblems);
        return mainFrameInfo;
    }

    @Override
    protected SWFTarget.FramesInformation computeFramesInformation() throws InterruptedException {
        SWFTarget.SWFFrameInfo mainFrameInfo = this.createMainFrameInfo();
        SWFTarget.FramesInformation explicitFrames = this.getExplicitFramesInformation();
        Iterable frames = Iterables.concat(Collections.singletonList(mainFrameInfo), explicitFrames.frameInfos);
        return new AppFramesInformation(frames, this.targetSettings.getRootClassName());
    }

    @Override
    protected void addLinkedABCToFrame(SWFFrame targetFrame, Iterable<DoABCTag> inputABCs, ABCLinker.ABCLinkerSettings linkSettings) throws Exception {
        Iterable inputABCsBytes = Iterables.transform(inputABCs, (Function)new Function<DoABCTag, byte[]>(){

            public byte[] apply(DoABCTag arg0) {
                return arg0.getABCData();
            }
        });
        byte[] linkedBytes = ABCLinker.linkABC(inputABCsBytes, 46, 16, linkSettings);
        DoABCTag linkedTag = new DoABCTag(1L, "merged", linkedBytes);
        targetFrame.addTag(linkedTag);
    }

    @Override
    protected void setKeepAS3MetadataLinkerSetting(ABCLinker.ABCLinkerSettings linkSettings) {
        ITargetSettings settings = this.getTargetSettings();
        Collection<String> metadataNames = this.getASMetadataNames();
        if (settings.isDebugEnabled() && metadataNames != null) {
            ArrayList<String> names = new ArrayList<String>(metadataNames);
            names.add("__go_to_definition_help");
            names.add("__go_to_ctor_definition_help");
            metadataNames = names;
        }
        linkSettings.setKeepMetadata(metadataNames);
    }

    private ClassDefinition computeRootClassDefinition() {
        IResolvedQualifiersReference rootClassRef = this.getRootClassReference();
        if (rootClassRef == null) {
            return null;
        }
        IDefinition rootClassDef = rootClassRef.resolve(this.project);
        if (!(rootClassDef instanceof ClassDefinition)) {
            return null;
        }
        return (ClassDefinition)rootClassDef;
    }

    protected ClassDefinition getRootClassDefinition() {
        if (this.rootClassDefinition != null) {
            return this.rootClassDefinition;
        }
        this.rootClassDefinition = this.computeRootClassDefinition();
        return this.rootClassDefinition;
    }

    protected final ICompilationUnit getRootClassCompilationUnit() {
        String rootClassFileName = this.targetSettings.getRootSourceFileName();
        if (rootClassFileName == null) {
            return null;
        }
        Collection<ICompilationUnit> rootClassCompilationUnits = this.project.getCompilationUnits(rootClassFileName);
        assert (rootClassCompilationUnits.size() == 1) : "There must only be a single compilation unit for the root source file!";
        return (ICompilationUnit)Iterables.getOnlyElement(rootClassCompilationUnits);
    }

    private IResolvedQualifiersReference getRootClassReference() {
        String rootClassName = this.targetSettings.getRootClassName();
        if (rootClassName == null) {
            return null;
        }
        return ReferenceFactory.packageQualifiedReference(this.project.getWorkspace(), rootClassName, true);
    }

    @Override
    protected ISWF linkSWF(ISWF unLinked) {
        if (!this.targetSettings.isOptimized()) {
            return unLinked;
        }
        return super.linkSWF(unLinked);
    }

    private static final class AppFramesInformation
    extends SWFTarget.FramesInformation {
        private final String rootClassName;

        AppFramesInformation(Iterable<SWFTarget.SWFFrameInfo> frameInfos, String rootClassName) {
            super(frameInfos);
            this.rootClassName = rootClassName;
        }

        @Override
        protected void createFrames(SWFTarget swfTarget, ISWF swf, ImmutableSet<ICompilationUnit> builtCompilationUnits, Set<ICompilationUnit> emittedCompilationUnits, Collection<ICompilerProblem> problems) throws InterruptedException {
            super.createFrames(swfTarget, swf, builtCompilationUnits, emittedCompilationUnits, problems);
            swf.setTopLevelClass(this.rootClassName);
        }
    }
}

