/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.fxg.dom.richtext;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.flex.compiler.fxg.dom.IFXGNode;
import org.apache.flex.compiler.internal.fxg.dom.CDATANode;
import org.apache.flex.compiler.internal.fxg.dom.ITextNode;
import org.apache.flex.compiler.internal.fxg.dom.richtext.AbstractRichParagraphNode;
import org.apache.flex.compiler.internal.fxg.dom.richtext.AbstractRichTextNode;
import org.apache.flex.compiler.internal.fxg.dom.richtext.BRNode;
import org.apache.flex.compiler.internal.fxg.dom.richtext.ImgNode;
import org.apache.flex.compiler.internal.fxg.dom.richtext.LinkNode;
import org.apache.flex.compiler.internal.fxg.dom.richtext.SpanNode;
import org.apache.flex.compiler.internal.fxg.dom.richtext.TCYNode;
import org.apache.flex.compiler.internal.fxg.dom.richtext.TabNode;
import org.apache.flex.compiler.internal.fxg.dom.richtext.TextLayoutFormatNode;
import org.apache.flex.compiler.problems.FXGMissingAttributeProblem;
import org.apache.flex.compiler.problems.FXGMultipleElementProblem;
import org.apache.flex.compiler.problems.FXGUnknownAttributeValueProblem;
import org.apache.flex.compiler.problems.ICompilerProblem;

public class ParagraphNode
extends AbstractRichParagraphNode {
    public TextLayoutFormatNode linkNormalFormat = null;
    public TextLayoutFormatNode linkHoverFormat = null;
    public TextLayoutFormatNode linkActiveFormat = null;
    protected Map<String, ITextNode> properties;

    @Override
    public Map<String, ITextNode> getTextProperties() {
        return this.properties;
    }

    @Override
    public void addTextProperty(String propertyName, ITextNode node, Collection<ICompilerProblem> problems) {
        if (node instanceof TextLayoutFormatNode) {
            if ("linkActiveFormat".equals(propertyName)) {
                if (this.linkActiveFormat == null) {
                    this.linkActiveFormat = (TextLayoutFormatNode)node;
                    this.linkActiveFormat.setParent(this);
                    if (this.properties == null) {
                        this.properties = new HashMap<String, ITextNode>(3);
                    }
                    this.properties.put(propertyName, this.linkActiveFormat);
                } else {
                    problems.add(new FXGMultipleElementProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), propertyName));
                }
            } else if ("linkHoverFormat".equals(propertyName)) {
                if (this.linkHoverFormat == null) {
                    this.linkHoverFormat = (TextLayoutFormatNode)node;
                    this.linkHoverFormat.setParent(this);
                    if (this.properties == null) {
                        this.properties = new HashMap<String, ITextNode>(3);
                    }
                    this.properties.put(propertyName, this.linkHoverFormat);
                } else {
                    problems.add(new FXGMultipleElementProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), propertyName));
                }
            } else if ("linkNormalFormat".equals(propertyName)) {
                if (this.linkNormalFormat == null) {
                    this.linkNormalFormat = (TextLayoutFormatNode)node;
                    this.linkNormalFormat.setParent(this);
                    if (this.properties == null) {
                        this.properties = new HashMap<String, ITextNode>(3);
                    }
                    this.properties.put(propertyName, this.linkNormalFormat);
                } else {
                    problems.add(new FXGMultipleElementProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), propertyName));
                }
            } else {
                problems.add(new FXGUnknownAttributeValueProblem(this.getDocumentPath(), node.getStartLine(), node.getStartColumn(), node.getNodeName(), propertyName));
            }
        } else {
            super.addTextProperty(propertyName, node, problems);
        }
    }

    @Override
    public String getNodeName() {
        return "p";
    }

    @Override
    public void addChild(IFXGNode child, Collection<ICompilerProblem> problems) {
        if (child instanceof TCYNode || child instanceof LinkNode || child instanceof SpanNode || child instanceof BRNode || child instanceof TabNode || child instanceof ImgNode || child instanceof CDATANode) {
            if (child instanceof LinkNode && ((LinkNode)child).href == null) {
                problems.add(new FXGMissingAttributeProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), "href", child.getNodeName()));
                return;
            }
            if (this.content == null) {
                this.content = new ArrayList();
            }
        } else {
            super.addChild(child, problems);
            return;
        }
        this.content.add((ITextNode)child);
        if (child instanceof AbstractRichTextNode) {
            ((AbstractRichTextNode)child).setParent(this);
        }
    }
}

