/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.embedding.transcoders;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.flex.compiler.common.IFileSpecificationGetter;
import org.apache.flex.compiler.common.ISourceLocation;
import org.apache.flex.compiler.internal.embedding.EmbedAttribute;
import org.apache.flex.compiler.internal.embedding.EmbedData;
import org.apache.flex.compiler.internal.embedding.transcoders.TranscoderBase;
import org.apache.flex.compiler.internal.parsing.as.ASToken;
import org.apache.flex.compiler.internal.semantics.PostProcessStep;
import org.apache.flex.compiler.internal.tree.as.ClassNode;
import org.apache.flex.compiler.internal.tree.as.FileNode;
import org.apache.flex.compiler.internal.tree.as.IdentifierNode;
import org.apache.flex.compiler.internal.tree.as.LiteralNode;
import org.apache.flex.compiler.internal.tree.as.ModifierNode;
import org.apache.flex.compiler.internal.tree.as.NamespaceIdentifierNode;
import org.apache.flex.compiler.internal.tree.as.PackageNode;
import org.apache.flex.compiler.internal.tree.as.ScopedBlockNode;
import org.apache.flex.compiler.internal.tree.as.VariableNode;
import org.apache.flex.compiler.internal.workspaces.Workspace;
import org.apache.flex.compiler.problems.EmbedSourceAttributeCouldNotBeReadProblem;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.tree.as.ILiteralNode;
import org.apache.flex.swf.tags.ICharacterTag;
import org.apache.flex.swf.tags.ITag;

public class XMLTranscoder
extends TranscoderBase {
    private String encoding = "";

    public XMLTranscoder(EmbedData data, Workspace workspace) {
        super(data, workspace);
    }

    @Override
    public boolean analyze(ISourceLocation location, Collection<ICompilerProblem> problems) {
        boolean result = super.analyze(location, problems);
        this.baseClassQName = "";
        return result;
    }

    @Override
    protected boolean setAttribute(EmbedAttribute attribute) {
        boolean isSupported = true;
        switch (attribute) {
            case ENCODING: {
                this.encoding = (String)this.data.getAttribute(EmbedAttribute.ENCODING);
                break;
            }
            default: {
                isSupported = super.setAttribute(attribute);
            }
        }
        return isSupported;
    }

    @Override
    protected Map<String, ICharacterTag> doTranscode(Collection<ITag> tags, Collection<ICompilerProblem> problems) {
        return Collections.emptyMap();
    }

    @Override
    public FileNode buildAST(Collection<ICompilerProblem> problems, String filename) {
        FileNode fileNode = new FileNode((IFileSpecificationGetter)this.workspace, filename);
        PackageNode packageNode = new PackageNode(new IdentifierNode(""), null);
        fileNode.addItem(packageNode);
        ScopedBlockNode contents = packageNode.getScopedNode();
        ClassNode classNode = new ClassNode(new IdentifierNode(this.data.getQName()));
        classNode.setNamespace(new NamespaceIdentifierNode("public"));
        contents.addItem(classNode);
        VariableNode variableNodeData = new VariableNode(new IdentifierNode("data"));
        variableNodeData.setNamespace(new NamespaceIdentifierNode("public"));
        variableNodeData.addModifier(new ModifierNode("static"));
        variableNodeData.setType(null, new IdentifierNode("XML"));
        ASToken assignToken = new ASToken(52, -1, -1, -1, -1, "=");
        String xmlContents = this.getXMLString(problems);
        LiteralNode xmlData = new LiteralNode(ILiteralNode.LiteralType.STRING, xmlContents);
        variableNodeData.setAssignedValue(assignToken, xmlData);
        classNode.getScopedNode().addItem(variableNodeData);
        fileNode.runPostProcess(EnumSet.of(PostProcessStep.POPULATE_SCOPE));
        return fileNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getXMLString(Collection<ICompilerProblem> problems) {
        InputStream strm = this.getDataStream(problems);
        if (strm == null) {
            return "";
        }
        Reader reader = null;
        BOMInputStream bomStream = null;
        StringBuilder str = new StringBuilder();
        try {
            bomStream = new BOMInputStream(strm);
            String bomCharsetName = bomStream.getBOMCharsetName();
            if (bomCharsetName == null) {
                bomCharsetName = this.encoding == null || this.encoding.length() == 0 ? System.getProperty("file.encoding") : this.encoding;
            }
            reader = new InputStreamReader((InputStream)bomStream, bomCharsetName);
            char[] line = new char[2048];
            int count = 0;
            while ((count = reader.read(line, 0, line.length)) >= 0) {
                str.append(line, 0, count);
            }
        }
        catch (IOException e) {
            problems.add(new EmbedSourceAttributeCouldNotBeReadProblem(this.source));
        }
        finally {
            if (bomStream != null) {
                try {
                    bomStream.close();
                }
                catch (IOException iOException) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return str.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof XMLTranscoder)) {
            return false;
        }
        XMLTranscoder t = (XMLTranscoder)o;
        return this.encoding.equals(t.encoding);
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        return hashCode += this.encoding.hashCode();
    }
}

