/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.css;

import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.List;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.apache.flex.compiler.css.ConditionType;
import org.apache.flex.compiler.css.ICSSCombinator;
import org.apache.flex.compiler.css.ICSSSelector;
import org.apache.flex.compiler.css.ICSSSelectorCondition;
import org.apache.flex.compiler.internal.css.CSSCombinator;
import org.apache.flex.compiler.internal.css.CSSModelTreeType;
import org.apache.flex.compiler.internal.css.CSSNodeBase;
import org.apache.flex.compiler.internal.css.CSSSelectorCondition;

public class CSSSelector
extends CSSNodeBase
implements ICSSSelector {
    private final String elementName;
    private final String namespacePrefix;
    private final ImmutableList<ICSSSelectorCondition> conditions;
    private final CSSCombinator combinator;

    protected CSSSelector(CSSCombinator combinator, String elementName, String namespacePrefix, List<CSSSelectorCondition> conditions, CommonTree tree, TokenStream tokenStream) {
        super(tree, tokenStream, CSSModelTreeType.SELECTOR);
        boolean isEmptySelector;
        boolean bl = isEmptySelector = elementName == null && namespacePrefix == null && conditions == null;
        assert (!isEmptySelector) : "Invalid selector. Namespace, element and conditions are all null.";
        this.combinator = combinator;
        this.namespacePrefix = namespacePrefix;
        this.elementName = elementName;
        this.conditions = conditions == null || conditions.isEmpty() ? ImmutableList.of() : new ImmutableList.Builder().addAll(conditions).build();
    }

    @Override
    public String getElementName() {
        return this.elementName;
    }

    @Override
    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    @Override
    public ImmutableList<ICSSSelectorCondition> getConditions() {
        return this.conditions;
    }

    @Override
    public String toString() {
        return this.getCSSSyntax();
    }

    @Override
    public String getCSSSyntax() {
        StringBuilder result = new StringBuilder();
        if (this.combinator != null) {
            result.append(this.combinator.getSelector().toString()).append(this.combinator.getCombinatorType().text);
        }
        if (this.namespacePrefix != null) {
            result.append(this.namespacePrefix).append("|");
        }
        if (this.elementName != null) {
            result.append(this.elementName);
        }
        result.append(this.stringifyConditions((List<ICSSSelectorCondition>)this.conditions));
        return result.toString();
    }

    @Override
    public String stringifyConditions(List<ICSSSelectorCondition> conditions) {
        StringBuilder s = new StringBuilder();
        int n = conditions.size();
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            return conditions.get(0).toString();
        }
        for (int i = 0; i < n; ++i) {
            ICSSSelectorCondition condition = conditions.get(i);
            s.append(condition.getConditionType().prefix);
            s.append(condition.getValue());
        }
        return s.toString();
    }

    @Override
    public ICSSCombinator getCombinator() {
        return this.combinator;
    }

    public static ImmutableList<ICSSSelector> getCombinedSelectorList(ICSSSelector selector) {
        ArrayDeque<ICSSSelector> deque = new ArrayDeque<ICSSSelector>();
        while (selector != null) {
            deque.offerFirst(selector);
            if (selector.getCombinator() == null) {
                selector = null;
                continue;
            }
            selector = selector.getCombinator().getSelector();
        }
        return ImmutableList.copyOf(deque);
    }

    @Override
    public boolean isAdvanced() {
        if (this.namespacePrefix != null) {
            return true;
        }
        for (ICSSSelectorCondition condition : this.conditions) {
            if (condition.getConditionType() == ConditionType.CLASS) continue;
            return true;
        }
        if (this.combinator != null) {
            return true;
        }
        return "*".equals(this.elementName);
    }
}

