/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.clients.problems;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import org.apache.commons.io.input.NullReader;
import org.apache.flex.compiler.clients.problems.CompilerProblemCategorizer;
import org.apache.flex.compiler.clients.problems.ProblemFormatter;
import org.apache.flex.compiler.filespecs.IFileSpecification;
import org.apache.flex.compiler.internal.workspaces.Workspace;
import org.apache.flex.compiler.problems.CompilerProblemClassification;
import org.apache.flex.compiler.problems.CompilerProblemSeverity;
import org.apache.flex.compiler.problems.ICompilerProblem;

public final class WorkspaceProblemFormatter
extends ProblemFormatter {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final int MAX_CACHED_LINES_PER_FILE = 10;
    private static String ERROR_FORMAT_ID = "ErrorFormat";
    private static String WARNING_FORMAT_ID = "WarningFormat";
    private static String SYNTAXERROR_FORMAT_ID = "SyntaxErrorFormat";
    private static String INTERNALERROR_FORMAT_ID = "InternalErrorFormat";
    private static String LOCATION_FORMAT_ID = "LocationFormat";
    private static String LOCATION_FORMAT_STRING = "%s(%d): col: %d";
    private final Workspace workspace;
    private final LoadingCache<String, FileLineInfo> readers;
    private final CompilerProblemCategorizer problemCategorizer;

    public WorkspaceProblemFormatter(Workspace workspace) {
        this(workspace, null);
    }

    public WorkspaceProblemFormatter(Workspace workspace, CompilerProblemCategorizer problemCategorizer) {
        this.workspace = workspace;
        this.problemCategorizer = problemCategorizer;
        this.readers = CacheBuilder.newBuilder().concurrencyLevel(1).softValues().build((CacheLoader)new CacheLoader<String, FileLineInfo>(){

            public FileLineInfo load(String fileName) {
                return new FileLineInfo(fileName);
            }
        });
    }

    @Override
    public String format(ICompilerProblem problem) {
        StringBuffer buffer = new StringBuffer();
        String locationString = this.getLocationString(problem.getSourcePath(), problem.getLine(), problem.getColumn());
        if (!locationString.isEmpty()) {
            buffer.append(locationString);
            buffer.append(" ");
        }
        String description = super.format(problem);
        if (this.problemCategorizer != null) {
            description = String.format(this.getProblemFormat(problem), description);
        }
        assert (description != null);
        buffer.append(description);
        buffer.append(NEW_LINE);
        buffer.append(NEW_LINE);
        String lineText = this.getLineText(problem);
        if (lineText != null) {
            buffer.append(lineText);
            buffer.append(NEW_LINE);
            buffer.append(this.getLinePointer(lineText, problem.getColumn()));
            buffer.append(NEW_LINE);
        }
        return buffer.toString();
    }

    private String getProblemFormat(ICompilerProblem problem) {
        CompilerProblemSeverity severity = this.problemCategorizer.getProblemSeverity(problem);
        CompilerProblemClassification classification = this.problemCategorizer.getProblemClassification(problem);
        String formatString = null;
        if (classification == CompilerProblemClassification.DEFAULT) {
            switch (severity) {
                case ERROR: {
                    formatString = this.getErrorFormat();
                    break;
                }
                case WARNING: {
                    formatString = this.getWarningFormat();
                    break;
                }
                default: {
                    assert (false);
                    formatString = this.getErrorFormat();
                    break;
                }
            }
        } else {
            switch (classification) {
                case SYNTAX_ERROR: {
                    formatString = this.getSyntaxErrorFormat();
                    break;
                }
                case INTERNAL_ERROR: {
                    formatString = this.getInternalErrorFormat();
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        assert (formatString != null);
        return formatString;
    }

    protected String getLineText(ICompilerProblem problem) {
        String filePath = problem.getSourcePath();
        if (filePath == null) {
            return null;
        }
        int lineNumber = problem.getLine();
        if (lineNumber < 0) {
            return null;
        }
        FileLineInfo fileLineInfo = (FileLineInfo)this.readers.getUnchecked((Object)filePath);
        return fileLineInfo.getLineText(lineNumber);
    }

    private String getLinePointer(String lineText, int column) {
        if (lineText == null || column == -1) {
            return "";
        }
        StringBuilder b = new StringBuilder(column);
        int len = lineText.length();
        for (int i = 0; i < column; ++i) {
            if (i < len && lineText.charAt(i) == '\t') {
                b.append('\t');
                continue;
            }
            b.append(' ');
        }
        b.append('^');
        return b.toString();
    }

    private String getLocationString(String filePath, int line, int col) {
        if (filePath == null) {
            return "";
        }
        String location = filePath;
        if (line != -1) {
            location = String.format(this.getLocationFormat(), location, line + 1, col + 1);
        }
        assert (location != null);
        return location;
    }

    private String getErrorFormat() {
        return this.getMessage(ERROR_FORMAT_ID);
    }

    private String getWarningFormat() {
        return this.getMessage(WARNING_FORMAT_ID);
    }

    private String getSyntaxErrorFormat() {
        return this.getMessage(SYNTAXERROR_FORMAT_ID);
    }

    private String getInternalErrorFormat() {
        return this.getMessage(INTERNALERROR_FORMAT_ID);
    }

    private String getLocationFormat() {
        String format = this.getMessage(LOCATION_FORMAT_ID);
        if (format != null) {
            return format;
        }
        return LOCATION_FORMAT_STRING;
    }

    private class FileLineInfo {
        final String fileName;
        LineNumberReader reader;
        final Cache<Integer, String> cachedLines;

        FileLineInfo(String fileName) {
            this.fileName = fileName;
            this.reader = this.createReader();
            this.cachedLines = CacheBuilder.newBuilder().concurrencyLevel(1).softValues().maximumSize(10L).build();
        }

        private LineNumberReader createReader() {
            Reader reader;
            IFileSpecification fileSpec = WorkspaceProblemFormatter.this.workspace.getFileSpecification(this.fileName);
            try {
                reader = fileSpec.createReader();
            }
            catch (FileNotFoundException e) {
                reader = new NullReader(0L);
            }
            return new LineNumberReader(reader);
        }

        String getLineText(int lineNumber) {
            String result = (String)this.cachedLines.getIfPresent((Object)lineNumber);
            if (result != null) {
                return result;
            }
            if (this.reader.getLineNumber() > lineNumber) {
                this.reader = this.createReader();
            }
            assert (this.reader.getLineNumber() <= lineNumber);
            try {
                while (this.reader.getLineNumber() < lineNumber) {
                    String lineText = this.reader.readLine();
                    if (lineText != null) continue;
                    return null;
                }
                result = this.reader.readLine();
                if (result == null) {
                    return null;
                }
                this.cachedLines.put((Object)lineNumber, (Object)result);
                return result;
            }
            catch (IOException e) {
                return null;
            }
        }
    }
}

