/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.ant.types;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.flex.compiler.ant.FlexTask;
import org.apache.flex.compiler.ant.config.ConfigString;
import org.apache.flex.compiler.ant.config.IOptionSource;
import org.apache.flex.compiler.ant.config.NestedAttributeElement;
import org.apache.flex.compiler.ant.config.OptionSpec;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicElement;
import org.apache.tools.ant.types.Commandline;

public final class Metadata
implements IOptionSource,
DynamicElement {
    private static final OptionSpec LOCALIZED_DESCRIPTION = new OptionSpec("metadata.localized-description");
    private static final OptionSpec LOCALIZED_TITLE = new OptionSpec("metadata.localized-title");
    private static final OptionSpec CONTRIBUTOR = new OptionSpec("metadata.contributor");
    private static final OptionSpec CREATOR = new OptionSpec("metadata.creator");
    private static final OptionSpec LANGUAGE = new OptionSpec("metadata.language");
    private static final OptionSpec PUBLISHER = new OptionSpec("metadata.publisher");
    private final ConfigString date = new ConfigString(new OptionSpec("metadata", "date"));
    private final ConfigString description = new ConfigString(new OptionSpec("metadata", "description"));
    private final ConfigString title = new ConfigString(new OptionSpec("metadata", "title"));
    private final ArrayList<NestedAttributeElement> nestedAttribs = new ArrayList();
    private final FlexTask task;

    public Metadata() {
        this(null);
    }

    public Metadata(FlexTask task) {
        this.task = task;
    }

    public void setDate(String value) {
        this.date.set(value);
    }

    public void setDescription(String value) {
        this.description.set(value);
    }

    public void setTitle(String value) {
        this.title.set(value);
    }

    public NestedAttributeElement createContributor() {
        return this.createElem("name", CONTRIBUTOR);
    }

    public NestedAttributeElement createCreator() {
        return this.createElem("name", CREATOR);
    }

    public NestedAttributeElement createLanguage() {
        return this.createElem("code", LANGUAGE);
    }

    public NestedAttributeElement createPublisher() {
        return this.createElem("name", PUBLISHER);
    }

    public Object createDynamicElement(String name) {
        if (LOCALIZED_DESCRIPTION.matches(name)) {
            return this.createElem(new String[]{"text", "lang"}, LOCALIZED_DESCRIPTION);
        }
        if (LOCALIZED_TITLE.matches(name)) {
            return this.createElem(new String[]{"title", "lang"}, LOCALIZED_TITLE);
        }
        throw new BuildException("Invalid element: " + name);
    }

    private NestedAttributeElement createElem(String attrib, OptionSpec spec) {
        NestedAttributeElement e = new NestedAttributeElement(attrib, spec, this.task);
        this.nestedAttribs.add(e);
        return e;
    }

    private NestedAttributeElement createElem(String[] attribs, OptionSpec spec) {
        NestedAttributeElement e = new NestedAttributeElement(attribs, spec, this.task);
        this.nestedAttribs.add(e);
        return e;
    }

    @Override
    public void addToCommandline(Commandline cmdline) {
        this.date.addToCommandline(cmdline);
        this.description.addToCommandline(cmdline);
        this.title.addToCommandline(cmdline);
        Iterator<NestedAttributeElement> it = this.nestedAttribs.iterator();
        while (it.hasNext()) {
            ((IOptionSource)it.next()).addToCommandline(cmdline);
        }
    }
}

