/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.tools.debugger.Location;
import flash.tools.debugger.SourceFile;

public class DLocation
implements Location {
    SourceFile m_source;
    int m_line;
    int m_isolateId;
    boolean m_removed;

    DLocation(SourceFile sourceFile, int n, int n2) {
        this.m_source = sourceFile;
        this.m_line = n;
        this.m_removed = false;
        this.m_isolateId = n2;
    }

    @Override
    public SourceFile getFile() {
        return this.m_source;
    }

    @Override
    public int getLine() {
        return this.m_line;
    }

    public boolean isRemoved() {
        return this.m_removed;
    }

    public void setRemoved(boolean bl) {
        this.m_removed = bl;
    }

    public int getId() {
        return DLocation.encodeId(this.getFile().getId(), this.getLine());
    }

    public static final int encodeId(int n, int n2) {
        return n2 << 16 | n;
    }

    public static final int decodeFile(long l) {
        return (int)(l & 0xFFFFL);
    }

    public static final int decodeLine(long l) {
        return (int)(l >> 16 & 0xFFFFL);
    }

    public String toString() {
        return this.m_source.toString() + ":" + this.m_line;
    }

    @Override
    public int getIsolateId() {
        return this.m_isolateId;
    }
}

