/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger;

import flash.localization.ILocalizedText;
import flash.localization.ILocalizer;
import flash.localization.ResourceBundleLocalizer;
import java.util.Locale;
import java.util.Map;

public class DebuggerLocalizer
implements ILocalizer {
    private ResourceBundleLocalizer m_resourceBundleLocalizer = new ResourceBundleLocalizer();
    private String m_prefix;
    public static final String m_newline = System.getProperty("line.separator");

    public DebuggerLocalizer(String string) {
        this.m_prefix = string;
    }

    @Override
    public ILocalizedText getLocalizedText(Locale locale, final String string) {
        ILocalizedText iLocalizedText = this.m_resourceBundleLocalizer.getLocalizedText(locale, this.m_prefix + string);
        if (iLocalizedText == null && !Locale.getDefault().getLanguage().equals("en")) {
            iLocalizedText = this.m_resourceBundleLocalizer.getLocalizedText(Locale.ENGLISH, this.m_prefix + string);
        }
        if (iLocalizedText == null) {
            iLocalizedText = new ILocalizedText(){

                @Override
                public String format(Map map) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append('!');
                    stringBuilder.append(string);
                    stringBuilder.append('!');
                    if (map != null && !map.isEmpty()) {
                        stringBuilder.append(' ');
                        stringBuilder.append(map.toString());
                    }
                    return stringBuilder.toString();
                }
            };
        }
        if (m_newline.equals("\n")) {
            return iLocalizedText;
        }
        final ILocalizedText iLocalizedText2 = iLocalizedText;
        return new ILocalizedText(){

            @Override
            public String format(Map map) {
                String string = iLocalizedText2.format(map);
                return string.replaceAll("\n", m_newline);
            }
        };
    }
}

