/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.config;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.deltaspike.core.api.config.ConfigProperty;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.spi.config.BaseConfigPropertyProducer;

class ProxyConfigurationLifecycle {
    ProxyConfigurationLifecycle() {
    }

    private static class DefaultSupplier<T>
    implements Supplier<T> {
        private final ConfigResolver.TypedResolver<T> delegate;

        private DefaultSupplier(ConfigResolver.TypedResolver<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public T get() {
            return (T)this.delegate.getValue();
        }
    }

    private static interface Supplier<T> {
        public T get();
    }

    static final class ConfigurationHandler
    implements InvocationHandler {
        private final BaseConfigPropertyProducer delegate = new BaseConfigPropertyProducer(){};
        private final ConcurrentMap<Method, Supplier<?>> resolvers = new ConcurrentHashMap();
        private final long cacheMs;
        private final String prefix;

        ConfigurationHandler(long cacheMs, String prefix) {
            this.cacheMs = cacheMs;
            this.prefix = prefix;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (Object.class == method.getDeclaringClass()) {
                try {
                    return method.invoke((Object)this, args);
                }
                catch (InvocationTargetException ite) {
                    throw ite.getCause();
                }
            }
            Supplier<Object> supplier = (DefaultSupplier)this.resolvers.get(method);
            if (supplier == null) {
                boolean set;
                boolean list;
                ConfigProperty annotation = method.getAnnotation(ConfigProperty.class);
                if (annotation == null) {
                    throw new UnsupportedOperationException(method + " doesn't have @ConfigProperty and therefore is illegal");
                }
                Class converter = annotation.converter();
                Type genericReturnType = method.getGenericReturnType();
                Class returnType = method.getReturnType();
                if (converter == ConfigResolver.Converter.class && ParameterizedType.class.isInstance(genericReturnType)) {
                    Type arg;
                    ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(genericReturnType);
                    if (List.class == pt.getRawType() && pt.getActualTypeArguments().length == 1) {
                        list = true;
                        set = false;
                        arg = pt.getActualTypeArguments()[0];
                        if (Class.class.isInstance(arg)) {
                            returnType = (Class)Class.class.cast(arg);
                        }
                    } else if (Set.class == pt.getRawType() && pt.getActualTypeArguments().length == 1) {
                        list = false;
                        set = true;
                        arg = pt.getActualTypeArguments()[0];
                        if (Class.class.isInstance(arg)) {
                            returnType = (Class)Class.class.cast(arg);
                        }
                    } else {
                        list = false;
                        set = false;
                    }
                } else {
                    list = false;
                    set = false;
                    if (Integer.TYPE == returnType) {
                        returnType = Integer.class;
                    } else if (Long.TYPE == returnType) {
                        returnType = Long.class;
                    } else if (Boolean.TYPE == returnType) {
                        returnType = Boolean.class;
                    } else if (Short.TYPE == returnType) {
                        returnType = Short.class;
                    } else if (Byte.TYPE == returnType) {
                        returnType = Byte.class;
                    } else if (Float.TYPE == returnType) {
                        returnType = Float.class;
                    } else if (Double.TYPE == returnType) {
                        returnType = Double.class;
                    }
                }
                String defaultValue = annotation.defaultValue();
                ConfigResolver.TypedResolver typedResolver = this.delegate.asResolver(this.prefix + annotation.name(), list || set ? "org.apache.deltaspike.NullValueMarker" : defaultValue, returnType, converter, annotation.parameterizedBy(), annotation.projectStageAware(), annotation.evaluateVariables());
                if (this.cacheMs > 0L) {
                    typedResolver.cacheFor(TimeUnit.MILLISECONDS, this.cacheMs);
                }
                if (list || set) {
                    ConfigResolver.TypedResolver listTypedResolver = typedResolver.asList();
                    final ConfigResolver.TypedResolver resolver = !"org.apache.deltaspike.NullValueMarker".equals(defaultValue) ? listTypedResolver.withStringDefault(defaultValue) : listTypedResolver;
                    supplier = list ? new DefaultSupplier(resolver) : new Supplier<Set<?>>(){

                        @Override
                        public Set<?> get() {
                            return new HashSet((Collection)resolver.getValue());
                        }
                    };
                } else {
                    supplier = new DefaultSupplier(typedResolver);
                }
                Supplier existing = this.resolvers.putIfAbsent(method, supplier);
                if (existing != null) {
                    supplier = existing;
                }
            }
            return supplier.get();
        }
    }
}

