/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.aninteger;

import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.TupleSketchIterator;
import org.apache.datasketches.tuple.Union;
import org.apache.datasketches.tuple.aninteger.IntegerSketch;
import org.apache.datasketches.tuple.aninteger.IntegerSummary;
import org.apache.datasketches.tuple.aninteger.IntegerSummarySetOperations;
import org.testng.annotations.Test;

public class EngagementTest {
    public static final int numStdDev = 2;

    @Test
    public void computeEngagementHistogram() {
        int i;
        int lgK = 8;
        int K = 256;
        int days = 30;
        int v = 0;
        IntegerSketch[] skArr = new IntegerSketch[30];
        for (i = 0; i < 30; ++i) {
            skArr[i] = new IntegerSketch(8, IntegerSummary.Mode.AlwaysOne);
        }
        for (i = 0; i <= 30; ++i) {
            int numIds = EngagementTest.numIDs(30, i);
            int numDays = EngagementTest.numDays(30, i);
            int myV = v++;
            for (int d = 0; d < numDays; ++d) {
                for (int id = 0; id < numIds; ++id) {
                    skArr[d].update((long)(myV + id), Integer.valueOf(1));
                }
            }
            v += numIds;
        }
        EngagementTest.unionOps(256, IntegerSummary.Mode.Sum, skArr);
    }

    private static int numIDs(int totalDays, int index) {
        double d = totalDays;
        double i = index;
        return (int)Math.round(Math.exp(i * Math.log(d) / d));
    }

    private static int numDays(int totalDays, int index) {
        double d = totalDays;
        double i = index;
        return (int)Math.round(Math.exp((d - i) * Math.log(d) / d));
    }

    private static void unionOps(int K, IntegerSummary.Mode mode, IntegerSketch ... sketches) {
        IntegerSummarySetOperations setOps = new IntegerSummarySetOperations(mode, mode);
        Union union = new Union(K, (SummarySetOperations)setOps);
        int len = sketches.length;
        for (IntegerSketch isk : sketches) {
            union.union((Sketch)isk);
        }
        CompactSketch result = union.getResult();
        TupleSketchIterator itr = result.iterator();
        int[] numDaysArr = new int[len + 1];
        while (itr.next()) {
            int numDaysVisited;
            int n = numDaysVisited = ((IntegerSummary)itr.getSummary()).getValue();
            numDaysArr[n] = numDaysArr[n] + 1;
        }
        EngagementTest.println("\nEngagement Histogram:");
        EngagementTest.println("Number of Unique Visitors by Number of Days Visited");
        EngagementTest.printf("%12s%12s%12s%12s\n", "Days Visited", "Estimate", "LB", "UB");
        int sumVisits = 0;
        double theta = result.getTheta();
        for (int i = 0; i < numDaysArr.length; ++i) {
            int visitorsAtDaysVisited = numDaysArr[i];
            if (visitorsAtDaysVisited == 0) continue;
            sumVisits += visitorsAtDaysVisited * i;
            double estVisitorsAtDaysVisited = (double)visitorsAtDaysVisited / theta;
            double lbVisitorsAtDaysVisited = result.getLowerBound(2, visitorsAtDaysVisited);
            double ubVisitorsAtDaysVisited = result.getUpperBound(2, visitorsAtDaysVisited);
            EngagementTest.printf("%12d%12.0f%12.0f%12.0f\n", i, estVisitorsAtDaysVisited, lbVisitorsAtDaysVisited, ubVisitorsAtDaysVisited);
        }
        double visitors = result.getEstimate();
        double lbVisitors = result.getLowerBound(2);
        double ubVisitors = result.getUpperBound(2);
        EngagementTest.printf("\n%12s%12s%12s%12s\n", "Totals", "Estimate", "LB", "UB");
        EngagementTest.printf("%12s%12.0f%12.0f%12.0f\n", "Visitors", visitors, lbVisitors, ubVisitors);
        double estVisits = (double)sumVisits / theta;
        double lbVisits = estVisits * lbVisitors / visitors;
        double ubVisits = estVisits * ubVisitors / visitors;
        EngagementTest.printf("%12s%12.0f%12.0f%12.0f\n\n", "Visits", estVisits, lbVisits, ubVisits);
    }

    private static void println(Object o) {
        EngagementTest.printf("%s\n", o.toString());
    }

    private static void printf(String fmt, Object ... args) {
    }
}

