/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllDirectFloatsSketch;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllDirectCompactFloatsSketchTest {
    private static final DefaultMemoryRequestServer memReqSvr = new DefaultMemoryRequestServer();
    private static final boolean enablePrinting = false;

    @Test
    public void checkRODirectUpdatable_ROandWritable() {
        int k = 20;
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)k);
        for (int i = 1; i <= k + 1; ++i) {
            sk.update((float)i);
        }
        byte[] byteArr = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        Memory srcMem = Memory.wrap((byte[])byteArr);
        KllFloatsSketch sk2 = KllFloatsSketch.wrap((Memory)srcMem);
        Assert.assertTrue((boolean)(sk2 instanceof KllDirectFloatsSketch));
        Assert.assertTrue((boolean)sk2.isMemoryUpdatableFormat());
        Assert.assertTrue((boolean)sk2.isReadOnly());
        Assert.assertEquals((float)sk2.getMinItem(), (float)1.0f);
        Assert.assertEquals((float)sk2.getMaxItem(), (float)21.0f);
        WritableMemory srcWmem = WritableMemory.writableWrap((byte[])byteArr);
        KllFloatsSketch sk3 = KllFloatsSketch.writableWrap((WritableMemory)srcWmem, (MemoryRequestServer)memReqSvr);
        Assert.assertTrue((boolean)(sk3 instanceof KllDirectFloatsSketch));
        KllDirectCompactFloatsSketchTest.println(sk3.toString(true, false));
        Assert.assertFalse((boolean)sk3.isReadOnly());
        sk3.update(22.0f);
        Assert.assertEquals((float)sk2.getMinItem(), (float)1.0f);
        Assert.assertEquals((float)sk2.getMaxItem(), (float)22.0f);
    }

    @Test
    public void checkRODirectCompact() {
        int k = 20;
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)k);
        for (int i = 1; i <= k + 1; ++i) {
            sk.update((float)i);
        }
        Memory srcMem = Memory.wrap((byte[])sk.toByteArray());
        KllFloatsSketch sk2 = KllFloatsSketch.wrap((Memory)srcMem);
        Assert.assertTrue((boolean)(sk2 instanceof KllDirectFloatsSketch.KllDirectCompactFloatsSketch));
        Assert.assertFalse((boolean)sk2.isMemoryUpdatableFormat());
        Assert.assertTrue((boolean)sk2.isReadOnly());
        Assert.assertEquals((float)sk2.getMinItem(), (float)1.0f);
        Assert.assertEquals((float)sk2.getMaxItem(), (float)21.0f);
        Memory srcMem2 = Memory.wrap((byte[])sk2.toByteArray());
        KllFloatsSketch sk3 = KllFloatsSketch.writableWrap((WritableMemory)((WritableMemory)srcMem2), (MemoryRequestServer)memReqSvr);
        Assert.assertTrue((boolean)(sk3 instanceof KllDirectFloatsSketch.KllDirectCompactFloatsSketch));
        Assert.assertFalse((boolean)sk2.isMemoryUpdatableFormat());
        Assert.assertTrue((boolean)sk3.isReadOnly());
        Assert.assertEquals((float)sk3.getMinItem(), (float)1.0f);
        Assert.assertEquals((float)sk3.getMaxItem(), (float)21.0f);
    }

    @Test
    public void checkDirectCompactSingleItem() {
        int k = 20;
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)k);
        sk.update(1.0f);
        KllFloatsSketch sk2 = KllFloatsSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()));
        Assert.assertTrue((boolean)(sk2 instanceof KllDirectFloatsSketch.KllDirectCompactFloatsSketch));
        Assert.assertTrue((boolean)sk2.isReadOnly());
        Assert.assertEquals((float)sk2.getFloatSingleItem(), (float)1.0f);
        sk.update(2.0f);
        sk2 = KllFloatsSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()));
        Assert.assertEquals((long)sk2.getN(), (long)2L);
        try {
            sk2.getFloatSingleItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkDirectCompactGetFloatItemsArray() {
        int i;
        int k = 20;
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)k);
        KllFloatsSketch sk2 = KllFloatsSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()));
        float[] itemsArr = sk2.getFloatItemsArray();
        for (i = 0; i < 20; ++i) {
            Assert.assertEquals((float)itemsArr[i], (float)0.0f);
        }
        sk.update(1.0f);
        sk2 = KllFloatsSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()));
        itemsArr = sk2.getFloatItemsArray();
        for (i = 0; i < 19; ++i) {
            Assert.assertEquals((float)itemsArr[i], (float)0.0f);
        }
        Assert.assertEquals((float)itemsArr[19], (float)1.0f);
        for (i = 2; i <= 21; ++i) {
            sk.update((float)i);
        }
        sk2 = KllFloatsSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()));
        itemsArr = sk2.getFloatItemsArray();
        Assert.assertEquals((int)itemsArr.length, (int)33);
        Assert.assertEquals((float)itemsArr[22], (float)21.0f);
    }

    @Test
    public void checkHeapAndDirectCompactGetRetainedItemsArray() {
        int k = 20;
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)k);
        float[] retArr = sk.getFloatRetainedItemsArray();
        Assert.assertEquals((int)retArr.length, (int)0);
        KllFloatsSketch sk2 = KllFloatsSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()));
        retArr = sk2.getFloatRetainedItemsArray();
        Assert.assertEquals((int)retArr.length, (int)sk.getNumRetained());
        Assert.assertEquals((int)retArr.length, (int)0);
        sk.update(1.0f);
        retArr = sk.getFloatRetainedItemsArray();
        Assert.assertEquals((int)retArr.length, (int)sk.getNumRetained());
        Assert.assertEquals((int)retArr.length, (int)1);
        Assert.assertEquals((float)retArr[0], (float)1.0f);
        sk2 = KllFloatsSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()));
        retArr = sk2.getFloatRetainedItemsArray();
        Assert.assertEquals((int)retArr.length, (int)sk.getNumRetained());
        Assert.assertEquals((int)retArr.length, (int)1);
        Assert.assertEquals((float)retArr[0], (float)1.0f);
        for (int i = 2; i <= 21; ++i) {
            sk.update((float)i);
        }
        retArr = sk.getFloatRetainedItemsArray();
        Assert.assertEquals((int)retArr.length, (int)sk.getNumRetained());
        Assert.assertEquals((int)retArr.length, (int)11);
        sk2 = KllFloatsSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()));
        Assert.assertEquals((int)retArr.length, (int)sk2.getNumRetained());
        Assert.assertEquals((int)retArr.length, (int)11);
    }

    @Test
    public void checkMinAndMax() {
        int k = 20;
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)k);
        KllFloatsSketch sk2 = KllFloatsSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()));
        try {
            sk2.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        sk.update(1.0f);
        sk2 = KllFloatsSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()));
        Assert.assertEquals((float)sk2.getMaxItem(), (float)1.0f);
        Assert.assertEquals((float)sk2.getMinItem(), (float)1.0f);
        for (int i = 2; i <= 21; ++i) {
            sk.update((float)i);
        }
        sk2 = KllFloatsSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()));
        Assert.assertEquals((float)sk2.getMaxItem(), (float)21.0f);
        Assert.assertEquals((float)sk2.getMinItem(), (float)1.0f);
    }

    @Test
    public void checkQuantile() {
        KllFloatsSketch sk1 = KllFloatsSketch.newHeapInstance();
        for (int i = 1; i <= 1000; ++i) {
            sk1.update((float)i);
        }
        KllFloatsSketch sk2 = KllFloatsSketch.wrap((Memory)Memory.wrap((byte[])sk1.toByteArray()));
        double med2 = sk2.getQuantile(0.5);
        double med1 = sk1.getQuantile(0.5);
        Assert.assertEquals((double)med1, (double)med2);
        KllDirectCompactFloatsSketchTest.println("Med1: " + med1);
        KllDirectCompactFloatsSketchTest.println("Med2: " + med2);
    }

    @Test
    public void checkCompactSingleItemMerge() {
        int k = 20;
        KllFloatsSketch skH1 = KllFloatsSketch.newHeapInstance((int)k);
        skH1.update(21.0f);
        KllFloatsSketch skDC1 = KllFloatsSketch.wrap((Memory)Memory.wrap((byte[])skH1.toByteArray()));
        KllFloatsSketch skH20 = KllFloatsSketch.newHeapInstance((int)k);
        for (int i = 1; i <= 20; ++i) {
            skH20.update((float)i);
        }
        skH20.merge((KllSketch)skDC1);
        Assert.assertEquals((long)skH20.getN(), (long)21L);
        WritableMemory wmem = WritableMemory.allocate((int)1000);
        KllFloatsSketch skDU20 = KllFloatsSketch.newDirectInstance((int)k, (WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        for (int i = 1; i <= 20; ++i) {
            skDU20.update((float)i);
        }
        skDU20.merge((KllSketch)skDC1);
        Assert.assertEquals((long)skDU20.getN(), (long)21L);
    }

    @Test
    public void printlnTest() {
        KllDirectCompactFloatsSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    private static final void println(Object o) {
    }
}

