/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.JSCode;
import org.mozilla.javascript.JSFunction;
import org.mozilla.javascript.ScriptOrFn;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.debug.DebuggableScript;

public final class JSDescriptor<T extends ScriptOrFn<T>>
implements Serializable,
DebuggableScript {
    private static final long seria_ersio_ID = 5067677351589230234L;
    private static final int IS_STRICT_FLAG = 1;
    private static final int IS_SCRIPT_FLAG = 2;
    private static final int IS_TOP_LEVEL_FLAG = 4;
    private static final int IS_ES6_GENERATOR_FLAG = 8;
    private static final int IS_SHORTHAND_FLAG = 16;
    private static final int HAS_PROTOTYPE_FLAG = 32;
    private static final int HAS_LEXICAL_THIS_FLAG = 64;
    private static final int IS_EVAL_FUNCTION_FLAG = 128;
    private static final int HAS_REST_ARG_FLAG = 256;
    private static final int HAS_DEFAULT_PARAMETERS_FLAG = 512;
    private static final int REQUIRES_ACTIVATION_FRAME_FLAG = 1024;
    private static final int REQUIRES_ARGUMENT_OBJECT_FLAG = 2048;
    private static final int DECLARED_AS_FUNCTION_EXPRESSION_FLAG = 4096;
    private final JSCode<T> code;
    private final JSCode<T> constructor;
    private final JSDescriptor<?> parent;
    public List<JSDescriptor<JSFunction>> nestedFunctions;
    private final String[] paramAndVarNames;
    private final boolean[] paramIsConst;
    private final int flags;
    private final String sourceFile;
    private final String rawSource;
    private final int rawSourceStart;
    private final int rawSourceEnd;
    private final String name;
    private final int languageVersion;
    private final int paramAndVarCount;
    private final int paramCount;
    private final int arity;
    private final SecurityController securityController;
    private final Object securityDomain;
    private final int functionType;

    public JSDescriptor(JSCode<T> code, JSCode<T> constructor, JSDescriptor<?> parent, String[] paramAndVarNames, boolean[] paramIsConst, boolean isStrict, boolean isScript, boolean isTopLevel, boolean isES6Generator, boolean isShorthand, boolean hasPrototype, boolean hasLexicalThis, boolean isEvalFunction, boolean hasRestArg, String sourceFile, String rawSource, int rawSourceStart, int rawSourceEnd, String name, int languageVersion, int paramAndVarCount, int paramCount, int arity, boolean hasDefaultParameters, boolean requiresActivationFrame, boolean requiresArgumentObject, boolean declaredAsFunctionExpression, SecurityController securityController, Object securityDomain, int functionType) {
        this.code = code;
        this.constructor = constructor;
        this.parent = parent;
        this.paramAndVarNames = paramAndVarNames;
        this.paramIsConst = paramIsConst;
        int flags = 0;
        flags |= isStrict ? 1 : 0;
        flags |= isScript ? 2 : 0;
        flags |= isTopLevel ? 4 : 0;
        flags |= isES6Generator ? 8 : 0;
        flags |= isShorthand ? 16 : 0;
        flags |= hasPrototype ? 32 : 0;
        flags |= hasLexicalThis ? 64 : 0;
        flags |= isEvalFunction ? 128 : 0;
        flags |= hasRestArg ? 256 : 0;
        flags |= hasDefaultParameters ? 512 : 0;
        flags |= requiresActivationFrame ? 1024 : 0;
        flags |= requiresArgumentObject ? 2048 : 0;
        this.flags = flags |= declaredAsFunctionExpression ? 4096 : 0;
        this.sourceFile = sourceFile;
        this.rawSource = rawSource;
        this.rawSourceStart = rawSourceStart;
        this.rawSourceEnd = rawSourceEnd;
        this.name = name == null ? "" : name;
        this.languageVersion = languageVersion;
        this.paramAndVarCount = paramAndVarCount;
        this.paramCount = paramCount;
        this.arity = arity;
        this.securityController = securityController;
        this.securityDomain = securityDomain;
        this.functionType = functionType;
    }

    public JSCode<T> getCode() {
        return this.code;
    }

    public JSCode<T> getConstructor() {
        return this.constructor;
    }

    public List<JSDescriptor<JSFunction>> getNestedFunctions() {
        return this.nestedFunctions;
    }

    public boolean isStrict() {
        return (this.flags & 1) != 0;
    }

    public boolean isScript() {
        return (this.flags & 2) != 0;
    }

    @Override
    public boolean isTopLevel() {
        return (this.flags & 4) != 0;
    }

    @Override
    public boolean isFunction() {
        return this.functionType != 0;
    }

    public boolean isES6Generator() {
        return (this.flags & 8) != 0;
    }

    public boolean isShorthand() {
        return (this.flags & 0x10) != 0;
    }

    public boolean hasPrototype() {
        return (this.flags & 0x20) != 0;
    }

    public boolean hasLexicalThis() {
        return (this.flags & 0x40) != 0;
    }

    public boolean isEvalFunction() {
        return (this.flags & 0x80) != 0;
    }

    public boolean hasRestArg() {
        return (this.flags & 0x100) != 0;
    }

    @Override
    public String getSourceName() {
        return this.sourceFile;
    }

    public String getRawSource() {
        return this.rawSource.substring(this.rawSourceStart, this.rawSourceEnd);
    }

    public String getName() {
        return this.name;
    }

    public int getLanguageVersion() {
        return this.languageVersion;
    }

    @Override
    public int getParamAndVarCount() {
        return this.paramAndVarCount;
    }

    @Override
    public int getParamCount() {
        return this.paramCount;
    }

    public int getArity() {
        return this.arity;
    }

    public boolean getParamOrVarConst(int index) {
        return this.paramIsConst[index];
    }

    @Override
    public String getParamOrVarName(int index) {
        return this.paramAndVarNames[index];
    }

    public boolean hasDefaultParameters() {
        return (this.flags & 0x200) != 0;
    }

    public boolean hasFunctionNamed(String name) {
        for (int f = 0; f < this.getFunctionCount(); ++f) {
            DebuggableScript functionData = this.getFunction(f);
            if (((JSDescriptor)functionData).declaredAsFunctionExpression() || !name.equals(((JSDescriptor)functionData).getFunctionName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getFunctionCount() {
        return this.nestedFunctions == null ? 0 : this.nestedFunctions.size();
    }

    @Override
    public JSDescriptor<JSFunction> getFunction(int index) {
        return this.nestedFunctions.get(index);
    }

    @Override
    public String getFunctionName() {
        return this.name;
    }

    @Override
    public boolean isGeneratedScript() {
        return ScriptRuntime.isGeneratedScript(this.sourceFile);
    }

    @Override
    public int[] getLineNumbers() {
        return Interpreter.getLineNumbers(this);
    }

    public boolean requiresActivationFrame() {
        return (this.flags & 0x400) != 0;
    }

    public boolean requiresArgumentObject() {
        return (this.flags & 0x800) != 0;
    }

    public boolean declaredAsFunctionExpression() {
        return (this.flags & 0x1000) != 0;
    }

    public SecurityController getSecurityController() {
        return this.securityController;
    }

    public Object getSecurityDomain() {
        return this.securityDomain;
    }

    public int getFunctionType() {
        return this.functionType;
    }

    @Override
    public DebuggableScript getParent() {
        return this.parent;
    }

    public static class Builder<T extends ScriptOrFn<T>> {
        public JSCode.Builder<T> code;
        public JSCode.Builder<T> constructor;
        public Builder<?> parent;
        public final ArrayList<Builder<JSFunction>> nestedFunctions = new ArrayList();
        public String[] paramAndVarNames;
        public boolean[] paramIsConst;
        public boolean isStrict;
        public boolean isScript;
        public boolean isTopLevel;
        public boolean isES6Generator;
        public boolean isShorthand;
        public boolean hasPrototype;
        public boolean hasLexicalThis;
        public boolean isEvalFunction;
        public boolean hasRestArg;
        public String sourceFile;
        public String rawSource;
        public int rawSourceStart;
        public int rawSourceEnd;
        public String name;
        public int languageVersion;
        public int paramAndVarCount;
        public int paramCount;
        public int arity;
        public boolean hasDefaultParameters;
        public boolean requiresActivationFrame;
        public boolean requiresArgumentObject;
        public boolean declaredAsFunctionExpression;
        public SecurityController securityController;
        public Object securityDomain;
        public int functionType;

        public Builder() {
        }

        private Builder(Builder<?> parent) {
            this.parent = parent;
            this.languageVersion = parent.languageVersion;
            this.rawSource = parent.rawSource;
            this.sourceFile = parent.sourceFile;
            this.isStrict = parent.isStrict;
            this.securityController = parent.securityController;
            this.securityDomain = parent.securityDomain;
        }

        public Builder<JSFunction> createChildBuilder() {
            Builder<JSFunction> child = new Builder<JSFunction>(this);
            this.nestedFunctions.add(child);
            return child;
        }

        public JSDescriptor<T> build(Consumer<JSDescriptor<?>> consumer) {
            if (this.parent != null) {
                throw new Error();
            }
            return this.build(null, consumer);
        }

        private JSDescriptor<T> build(JSDescriptor<?> parent, Consumer<JSDescriptor<?>> consumer) {
            for (int i = 0; i < this.paramAndVarNames.length; ++i) {
                this.paramAndVarNames[i] = this.paramAndVarNames[i].intern();
            }
            JSDescriptor result = new JSDescriptor(this.code.build(), this.constructor.build(), parent, this.paramAndVarNames, this.paramIsConst, this.isStrict, this.isScript, this.isTopLevel, this.isES6Generator, this.isShorthand, this.hasPrototype, this.hasLexicalThis, this.isEvalFunction, this.hasRestArg, this.sourceFile, this.rawSource, this.rawSourceStart, this.rawSourceEnd, this.name == null ? null : this.name.intern(), this.languageVersion, this.paramAndVarCount, this.paramCount, this.arity, this.hasDefaultParameters, this.requiresActivationFrame, this.requiresArgumentObject, this.declaredAsFunctionExpression, this.securityController, this.securityDomain, this.functionType);
            consumer.accept(result);
            result.nestedFunctions = Collections.unmodifiableList(this.nestedFunctions.stream().map(x -> x.build(result, consumer)).collect(Collectors.toList()));
            return result;
        }

        public void setCode(JSCode.Builder<T> code) {
            this.code = code;
        }
    }
}

