/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client;

import io.micrometer.observation.ObservationRegistry;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInitializer;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.InterceptingClientHttpRequestFactory;
import org.springframework.http.client.JdkClientHttpRequestFactory;
import org.springframework.http.client.JettyClientHttpRequestFactory;
import org.springframework.http.client.ReactorClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.client.observation.ClientRequestObservationConvention;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverters;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ApiVersionInserter;
import org.springframework.web.client.DefaultRestClient;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.client.StatusHandler;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriBuilderFactory;
import org.springframework.web.util.UriTemplateHandler;

final class DefaultRestClientBuilder
implements RestClient.Builder {
    private static final boolean HTTP_COMPONENTS_CLIENT_PRESENT;
    private static final boolean JETTY_CLIENT_PRESENT;
    private static final boolean REACTOR_NETTY_CLIENT_PRESENT;
    private static final boolean JDK_CLIENT_PRESENT;
    private @Nullable String baseUrl;
    private @Nullable Map<String, ?> defaultUriVariables;
    private @Nullable UriBuilderFactory uriBuilderFactory;
    private @Nullable HttpHeaders defaultHeaders;
    private @Nullable MultiValueMap<String, String> defaultCookies;
    private @Nullable Object defaultApiVersion;
    private @Nullable ApiVersionInserter apiVersionInserter;
    private @Nullable Consumer<RestClient.RequestHeadersSpec<?>> defaultRequest;
    private @Nullable List<StatusHandler> statusHandlers;
    private @Nullable List<ClientHttpRequestInterceptor> interceptors;
    private @Nullable BiPredicate<URI, HttpMethod> bufferingPredicate;
    private @Nullable List<ClientHttpRequestInitializer> initializers;
    private @Nullable ClientHttpRequestFactory requestFactory;
    private @Nullable List<HttpMessageConverter<?>> messageConverters;
    private @Nullable Consumer<HttpMessageConverters.ClientBuilder> convertersConfigurer;
    private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;
    private @Nullable ClientRequestObservationConvention observationConvention;

    public DefaultRestClientBuilder() {
    }

    public DefaultRestClientBuilder(DefaultRestClientBuilder other) {
        Assert.notNull((Object)other, (String)"Other must not be null");
        this.baseUrl = other.baseUrl;
        this.defaultUriVariables = other.defaultUriVariables != null ? new LinkedHashMap(other.defaultUriVariables) : null;
        this.uriBuilderFactory = other.uriBuilderFactory;
        if (other.defaultHeaders != null) {
            this.defaultHeaders = new HttpHeaders();
            this.defaultHeaders.putAll(other.defaultHeaders);
        } else {
            this.defaultHeaders = null;
        }
        this.defaultCookies = other.defaultCookies != null ? new LinkedMultiValueMap(other.defaultCookies) : null;
        this.defaultApiVersion = other.defaultApiVersion;
        this.apiVersionInserter = other.apiVersionInserter;
        this.defaultRequest = other.defaultRequest;
        this.statusHandlers = other.statusHandlers != null ? new ArrayList<StatusHandler>(other.statusHandlers) : null;
        this.interceptors = other.interceptors != null ? new ArrayList<ClientHttpRequestInterceptor>(other.interceptors) : null;
        this.bufferingPredicate = other.bufferingPredicate;
        this.initializers = other.initializers != null ? new ArrayList<ClientHttpRequestInitializer>(other.initializers) : null;
        this.requestFactory = other.requestFactory;
        this.messageConverters = other.messageConverters != null ? new ArrayList(other.messageConverters) : null;
        this.convertersConfigurer = other.convertersConfigurer;
        this.observationRegistry = other.observationRegistry;
        this.observationConvention = other.observationConvention;
    }

    public DefaultRestClientBuilder(RestTemplate restTemplate) {
        Assert.notNull((Object)restTemplate, (String)"RestTemplate must not be null");
        this.uriBuilderFactory = DefaultRestClientBuilder.getUriBuilderFactory(restTemplate);
        this.statusHandlers = new ArrayList<StatusHandler>();
        this.statusHandlers.add(StatusHandler.fromErrorHandler(restTemplate.getErrorHandler()));
        if (!CollectionUtils.isEmpty(restTemplate.getInterceptors())) {
            this.interceptors = new ArrayList<ClientHttpRequestInterceptor>(restTemplate.getInterceptors());
        }
        this.bufferingPredicate = restTemplate.getBufferingPredicate();
        if (!CollectionUtils.isEmpty(restTemplate.getClientHttpRequestInitializers())) {
            this.initializers = new ArrayList<ClientHttpRequestInitializer>(restTemplate.getClientHttpRequestInitializers());
        }
        this.requestFactory = DefaultRestClientBuilder.getRequestFactory(restTemplate);
        this.messageConverters = new ArrayList(restTemplate.getMessageConverters());
        this.observationRegistry = restTemplate.getObservationRegistry();
        this.observationConvention = restTemplate.getObservationConvention();
    }

    private static @Nullable UriBuilderFactory getUriBuilderFactory(RestTemplate restTemplate) {
        UriTemplateHandler uriTemplateHandler = restTemplate.getUriTemplateHandler();
        if (uriTemplateHandler instanceof DefaultUriBuilderFactory) {
            DefaultUriBuilderFactory builderFactory = (DefaultUriBuilderFactory)uriTemplateHandler;
            if (DefaultRestClientBuilder.hasRestTemplateDefaults(builderFactory)) {
                return null;
            }
            return builderFactory;
        }
        if (uriTemplateHandler instanceof UriBuilderFactory) {
            UriBuilderFactory builderFactory = (UriBuilderFactory)uriTemplateHandler;
            return builderFactory;
        }
        return null;
    }

    private static boolean hasRestTemplateDefaults(DefaultUriBuilderFactory factory) {
        return !factory.hasBaseUri() && factory.getEncodingMode() == DefaultUriBuilderFactory.EncodingMode.URI_COMPONENT && CollectionUtils.isEmpty(factory.getDefaultUriVariables()) && factory.shouldParsePath();
    }

    private static ClientHttpRequestFactory getRequestFactory(RestTemplate restTemplate) {
        ClientHttpRequestFactory requestFactory = restTemplate.getRequestFactory();
        if (requestFactory instanceof InterceptingClientHttpRequestFactory) {
            InterceptingClientHttpRequestFactory interceptingClientHttpRequestFactory = (InterceptingClientHttpRequestFactory)requestFactory;
            return interceptingClientHttpRequestFactory.getDelegate();
        }
        return requestFactory;
    }

    @Override
    public RestClient.Builder baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    @Override
    public RestClient.Builder baseUrl(URI baseUrl) {
        this.baseUrl = baseUrl.toString();
        return this;
    }

    @Override
    public RestClient.Builder defaultUriVariables(Map<String, ?> defaultUriVariables) {
        this.defaultUriVariables = defaultUriVariables;
        return this;
    }

    @Override
    public RestClient.Builder uriBuilderFactory(UriBuilderFactory uriBuilderFactory) {
        this.uriBuilderFactory = uriBuilderFactory;
        return this;
    }

    @Override
    public RestClient.Builder defaultHeader(String header, String ... values) {
        this.initHeaders().put(header, Arrays.asList(values));
        return this;
    }

    @Override
    public RestClient.Builder defaultHeaders(Consumer<HttpHeaders> headersConsumer) {
        headersConsumer.accept(this.initHeaders());
        return this;
    }

    private HttpHeaders initHeaders() {
        if (this.defaultHeaders == null) {
            this.defaultHeaders = new HttpHeaders();
        }
        return this.defaultHeaders;
    }

    @Override
    public RestClient.Builder defaultCookie(String cookie, String ... values) {
        this.initCookies().addAll((Object)cookie, Arrays.asList(values));
        return this;
    }

    @Override
    public RestClient.Builder defaultCookies(Consumer<MultiValueMap<String, String>> cookiesConsumer) {
        cookiesConsumer.accept(this.initCookies());
        return this;
    }

    private MultiValueMap<String, String> initCookies() {
        if (this.defaultCookies == null) {
            this.defaultCookies = new LinkedMultiValueMap(3);
        }
        return this.defaultCookies;
    }

    @Override
    public RestClient.Builder defaultApiVersion(@Nullable Object version) {
        this.defaultApiVersion = version;
        return this;
    }

    @Override
    public RestClient.Builder apiVersionInserter(@Nullable ApiVersionInserter apiVersionInserter) {
        this.apiVersionInserter = apiVersionInserter;
        return this;
    }

    @Override
    public RestClient.Builder defaultRequest(Consumer<RestClient.RequestHeadersSpec<?>> defaultRequest) {
        this.defaultRequest = this.defaultRequest != null ? this.defaultRequest.andThen(defaultRequest) : defaultRequest;
        return this;
    }

    @Override
    public RestClient.Builder defaultStatusHandler(Predicate<HttpStatusCode> statusPredicate, RestClient.ResponseSpec.ErrorHandler errorHandler) {
        return this.defaultStatusHandlerInternal(StatusHandler.of(statusPredicate, errorHandler));
    }

    @Override
    public RestClient.Builder defaultStatusHandler(ResponseErrorHandler errorHandler) {
        return this.defaultStatusHandlerInternal(StatusHandler.fromErrorHandler(errorHandler));
    }

    private RestClient.Builder defaultStatusHandlerInternal(StatusHandler statusHandler) {
        if (this.statusHandlers == null) {
            this.statusHandlers = new ArrayList<StatusHandler>();
        }
        this.statusHandlers.add(statusHandler);
        return this;
    }

    @Override
    public RestClient.Builder requestInterceptor(ClientHttpRequestInterceptor interceptor) {
        Assert.notNull((Object)interceptor, (String)"Interceptor must not be null");
        this.initInterceptors().add(interceptor);
        return this;
    }

    @Override
    public RestClient.Builder requestInterceptors(Consumer<List<ClientHttpRequestInterceptor>> interceptorsConsumer) {
        interceptorsConsumer.accept(this.initInterceptors());
        return this;
    }

    private List<ClientHttpRequestInterceptor> initInterceptors() {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList<ClientHttpRequestInterceptor>();
        }
        return this.interceptors;
    }

    @Override
    public RestClient.Builder bufferContent(BiPredicate<URI, HttpMethod> predicate) {
        this.bufferingPredicate = predicate;
        return this;
    }

    @Override
    public RestClient.Builder requestInitializer(ClientHttpRequestInitializer initializer) {
        Assert.notNull((Object)initializer, (String)"Initializer must not be null");
        this.initInitializers().add(initializer);
        return this;
    }

    @Override
    public RestClient.Builder requestInitializers(Consumer<List<ClientHttpRequestInitializer>> initializersConsumer) {
        initializersConsumer.accept(this.initInitializers());
        return this;
    }

    private List<ClientHttpRequestInitializer> initInitializers() {
        if (this.initializers == null) {
            this.initializers = new ArrayList<ClientHttpRequestInitializer>();
        }
        return this.initializers;
    }

    @Override
    public RestClient.Builder requestFactory(ClientHttpRequestFactory requestFactory) {
        this.requestFactory = requestFactory;
        return this;
    }

    @Override
    public RestClient.Builder messageConverters(Consumer<List<HttpMessageConverter<?>>> configurer) {
        if (this.messageConverters == null) {
            this.messageConverters = new ArrayList();
            ((HttpMessageConverters.ClientBuilder)HttpMessageConverters.forClient().registerDefaults()).build().forEach(this.messageConverters::add);
        }
        configurer.accept(this.messageConverters);
        this.validateConverters(this.messageConverters);
        return this;
    }

    @Override
    public RestClient.Builder messageConverters(Iterable<HttpMessageConverter<?>> messageConverters) {
        this.validateConverters(messageConverters);
        ArrayList converters = new ArrayList();
        messageConverters.forEach(converters::add);
        this.messageConverters = converters;
        return this;
    }

    @Override
    public RestClient.Builder configureMessageConverters(Consumer<HttpMessageConverters.ClientBuilder> configurer) {
        this.convertersConfigurer = this.convertersConfigurer != null ? this.convertersConfigurer.andThen(configurer) : configurer;
        return this;
    }

    @Override
    public RestClient.Builder observationRegistry(ObservationRegistry observationRegistry) {
        Assert.notNull((Object)observationRegistry, (String)"observationRegistry must not be null");
        this.observationRegistry = observationRegistry;
        return this;
    }

    @Override
    public RestClient.Builder observationConvention(ClientRequestObservationConvention observationConvention) {
        this.observationConvention = observationConvention;
        return this;
    }

    @Override
    public RestClient.Builder apply(Consumer<RestClient.Builder> builderConsumer) {
        builderConsumer.accept(this);
        return this;
    }

    private void validateConverters(@Nullable Iterable<HttpMessageConverter<?>> converters) {
        Assert.notNull(converters, (String)"At least one HttpMessageConverter is required");
        Assert.isTrue((boolean)converters.iterator().hasNext(), (String)"At least one HttpMessageConverter is required");
        converters.forEach(converter -> Assert.notNull((Object)converter, (String)"The HttpMessageConverter list must not contain null elements"));
    }

    @Override
    public RestClient.Builder clone() {
        return new DefaultRestClientBuilder(this);
    }

    @Override
    public RestClient build() {
        ClientHttpRequestFactory requestFactory = this.initRequestFactory();
        UriBuilderFactory uriBuilderFactory = this.initUriBuilderFactory();
        HttpHeaders defaultHeaders = this.copyDefaultHeaders();
        MultiValueMap<String, String> defaultCookies = this.copyDefaultCookies();
        List<HttpMessageConverter<?>> converters = this.initMessageConverters();
        return new DefaultRestClient(requestFactory, this.interceptors, this.bufferingPredicate, this.initializers, uriBuilderFactory, defaultHeaders, defaultCookies, this.defaultApiVersion, this.apiVersionInserter, this.defaultRequest, this.statusHandlers, converters, this.observationRegistry, this.observationConvention, new DefaultRestClientBuilder(this));
    }

    private ClientHttpRequestFactory initRequestFactory() {
        if (this.requestFactory != null) {
            return this.requestFactory;
        }
        if (HTTP_COMPONENTS_CLIENT_PRESENT) {
            return new HttpComponentsClientHttpRequestFactory();
        }
        if (JETTY_CLIENT_PRESENT) {
            return new JettyClientHttpRequestFactory();
        }
        if (REACTOR_NETTY_CLIENT_PRESENT) {
            return new ReactorClientHttpRequestFactory();
        }
        if (JDK_CLIENT_PRESENT) {
            return new JdkClientHttpRequestFactory();
        }
        return new SimpleClientHttpRequestFactory();
    }

    private UriBuilderFactory initUriBuilderFactory() {
        if (this.uriBuilderFactory != null) {
            return this.uriBuilderFactory;
        }
        DefaultUriBuilderFactory factory = this.baseUrl != null ? new DefaultUriBuilderFactory(this.baseUrl) : new DefaultUriBuilderFactory();
        factory.setDefaultUriVariables(this.defaultUriVariables);
        return factory;
    }

    private @Nullable HttpHeaders copyDefaultHeaders() {
        if (this.defaultHeaders == null) {
            return null;
        }
        HttpHeaders copy = new HttpHeaders();
        this.defaultHeaders.forEach((key, values) -> copy.put((String)key, (List<String>)new ArrayList<String>((Collection<String>)values)));
        return HttpHeaders.readOnlyHttpHeaders(copy);
    }

    private @Nullable MultiValueMap<String, String> copyDefaultCookies() {
        if (this.defaultCookies == null) {
            return null;
        }
        LinkedMultiValueMap copy = new LinkedMultiValueMap(this.defaultCookies.size());
        this.defaultCookies.forEach((arg_0, arg_1) -> DefaultRestClientBuilder.lambda$copyDefaultCookies$0((MultiValueMap)copy, arg_0, arg_1));
        return CollectionUtils.unmodifiableMultiValueMap((MultiValueMap)copy);
    }

    private List<HttpMessageConverter<?>> initMessageConverters() {
        HttpMessageConverters.ClientBuilder builder = HttpMessageConverters.forClient();
        if (this.messageConverters == null && this.convertersConfigurer == null) {
            builder.registerDefaults();
        } else {
            if (this.messageConverters != null) {
                this.messageConverters.forEach(builder::addCustomConverter);
            }
            if (this.convertersConfigurer != null) {
                this.convertersConfigurer.accept(builder);
            }
        }
        ArrayList result = new ArrayList();
        builder.build().forEach(result::add);
        return result;
    }

    private static /* synthetic */ void lambda$copyDefaultCookies$0(MultiValueMap copy, String key, List values) {
        copy.put((Object)key, new ArrayList(values));
    }

    static {
        ClassLoader loader = DefaultRestClientBuilder.class.getClassLoader();
        HTTP_COMPONENTS_CLIENT_PRESENT = ClassUtils.isPresent((String)"org.apache.hc.client5.http.classic.HttpClient", (ClassLoader)loader);
        JETTY_CLIENT_PRESENT = ClassUtils.isPresent((String)"org.eclipse.jetty.client.HttpClient", (ClassLoader)loader);
        REACTOR_NETTY_CLIENT_PRESENT = ClassUtils.isPresent((String)"reactor.netty.http.client.HttpClient", (ClassLoader)loader);
        JDK_CLIENT_PRESENT = ClassUtils.isPresent((String)"java.net.http.HttpClient", (ClassLoader)loader);
    }
}

