/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec;

import java.net.SocketAddress;
import java.util.Queue;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.file.FileRegion;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.DefaultWriteRequest;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.filter.codec.AbstractProtocolDecoderOutput;
import org.apache.mina.filter.codec.AbstractProtocolEncoderOutput;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderException;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderException;
import org.apache.mina.filter.codec.RecoverableProtocolDecoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolCodecFilter
extends IoFilterAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolCodecFilter.class);
    private static final Class<?>[] EMPTY_PARAMS = new Class[0];
    private static final IoBuffer EMPTY_BUFFER = IoBuffer.wrap(new byte[0]);
    private static final AttributeKey ENCODER = new AttributeKey(ProtocolCodecFilter.class, "encoder");
    private static final AttributeKey DECODER = new AttributeKey(ProtocolCodecFilter.class, "decoder");
    private static final ProtocolDecoderOutputLocal DECODER_OUTPUT = new ProtocolDecoderOutputLocal();
    private static final ProtocolEncoderOutputLocal ENCODER_OUTPUT = new ProtocolEncoderOutputLocal();
    private final ProtocolCodecFactory factory;

    public ProtocolCodecFilter(ProtocolCodecFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory");
        }
        this.factory = factory;
    }

    public ProtocolCodecFilter(final ProtocolEncoder encoder, final ProtocolDecoder decoder) {
        if (encoder == null) {
            throw new IllegalArgumentException("encoder");
        }
        if (decoder == null) {
            throw new IllegalArgumentException("decoder");
        }
        this.factory = new ProtocolCodecFactory(){

            @Override
            public ProtocolEncoder getEncoder(IoSession session) {
                return encoder;
            }

            @Override
            public ProtocolDecoder getDecoder(IoSession session) {
                return decoder;
            }
        };
    }

    public ProtocolCodecFilter(Class<? extends ProtocolEncoder> encoderClass, Class<? extends ProtocolDecoder> decoderClass) {
        ProtocolDecoder decoder;
        ProtocolEncoder encoder;
        if (encoderClass == null) {
            throw new IllegalArgumentException("encoderClass");
        }
        if (decoderClass == null) {
            throw new IllegalArgumentException("decoderClass");
        }
        if (!ProtocolEncoder.class.isAssignableFrom(encoderClass)) {
            throw new IllegalArgumentException("encoderClass: " + encoderClass.getName());
        }
        if (!ProtocolDecoder.class.isAssignableFrom(decoderClass)) {
            throw new IllegalArgumentException("decoderClass: " + decoderClass.getName());
        }
        try {
            encoderClass.getConstructor(EMPTY_PARAMS);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("encoderClass doesn't have a public default constructor.");
        }
        try {
            decoderClass.getConstructor(EMPTY_PARAMS);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("decoderClass doesn't have a public default constructor.");
        }
        try {
            encoder = encoderClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("encoderClass cannot be initialized");
        }
        try {
            decoder = decoderClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("decoderClass cannot be initialized");
        }
        this.factory = new ProtocolCodecFactory(){

            @Override
            public ProtocolEncoder getEncoder(IoSession session) throws Exception {
                return encoder;
            }

            @Override
            public ProtocolDecoder getDecoder(IoSession session) throws Exception {
                return decoder;
            }
        };
    }

    public ProtocolEncoder getEncoder(IoSession session) {
        return (ProtocolEncoder)session.getAttribute(ENCODER);
    }

    @Override
    public void onPreAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        if (parent.contains(this)) {
            throw new IllegalArgumentException("You can't add the same filter instance more than once.  Create another instance and add it.");
        }
    }

    @Override
    public void onPostRemove(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        this.disposeCodec(parent.getSession());
    }

    @Override
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Processing a MESSAGE_RECEIVED for session {}", (Object)session.getId());
        }
        if (!(message instanceof IoBuffer)) {
            nextFilter.messageReceived(session, message);
            return;
        }
        IoBuffer in = (IoBuffer)message;
        ProtocolDecoder decoder = this.factory.getDecoder(session);
        ProtocolDecoderOutputImpl decoderOut = (ProtocolDecoderOutputImpl)DECODER_OUTPUT.get();
        while (in.hasRemaining()) {
            int oldPos = in.position();
            try {
                decoder.decode(session, in, decoderOut);
                decoderOut.flush(nextFilter, session);
            }
            catch (Exception e) {
                ProtocolDecoderException pde = e instanceof ProtocolDecoderException ? (ProtocolDecoderException)e : new ProtocolDecoderException(e);
                if (pde.getHexdump() == null) {
                    int curPos = in.position();
                    in.position(oldPos);
                    pde.setHexdump(in.getHexDump());
                    in.position(curPos);
                }
                decoderOut.flush(nextFilter, session);
                nextFilter.exceptionCaught(session, pde);
                if (e instanceof RecoverableProtocolDecoderException && in.position() != oldPos) continue;
                break;
            }
        }
        in.free();
    }

    @Override
    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        if (writeRequest instanceof EncodedWriteRequest) {
            return;
        }
        nextFilter.messageSent(session, writeRequest);
    }

    @Override
    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        block9: {
            Object message = writeRequest.getMessage();
            if (message instanceof IoBuffer || message instanceof FileRegion) {
                nextFilter.filterWrite(session, writeRequest);
                return;
            }
            ProtocolEncoder encoder = this.factory.getEncoder(session);
            ProtocolEncoderOutputImpl encoderOut = (ProtocolEncoderOutputImpl)ENCODER_OUTPUT.get();
            if (encoder == null) {
                throw new ProtocolEncoderException("The encoder is null for the session " + session);
            }
            try {
                encoder.encode(session, message, encoderOut);
                Queue queue = encoderOut.messageQueue;
                if (queue.isEmpty()) {
                    writeRequest.setMessage(EMPTY_BUFFER);
                    nextFilter.filterWrite(session, writeRequest);
                    break block9;
                }
                Object encodedMessage = null;
                while (true) {
                    Object e = queue.poll();
                    encodedMessage = e;
                    if (e != null) {
                        if (queue.isEmpty()) {
                            writeRequest.setMessage(encodedMessage);
                            nextFilter.filterWrite(session, writeRequest);
                            continue;
                        }
                        SocketAddress destination = writeRequest.getDestination();
                        EncodedWriteRequest encodedWriteRequest = new EncodedWriteRequest(encodedMessage, null, destination);
                        nextFilter.filterWrite(session, encodedWriteRequest);
                        continue;
                    }
                    break;
                }
            }
            catch (ProtocolEncoderException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ProtocolEncoderException(e);
            }
        }
    }

    @Override
    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        ProtocolDecoder decoder = this.factory.getDecoder(session);
        ProtocolDecoderOutput decoderOut = (ProtocolDecoderOutput)DECODER_OUTPUT.get();
        try {
            decoder.finishDecode(session, decoderOut);
        }
        catch (Exception e) {
            ProtocolDecoderException pde = e instanceof ProtocolDecoderException ? (ProtocolDecoderException)e : new ProtocolDecoderException(e);
            throw pde;
        }
        finally {
            this.disposeCodec(session);
            decoderOut.flush(nextFilter, session);
        }
        nextFilter.sessionClosed(session);
    }

    private void disposeCodec(IoSession session) {
        this.disposeEncoder(session);
        this.disposeDecoder(session);
    }

    private void disposeEncoder(IoSession session) {
        ProtocolEncoder encoder = (ProtocolEncoder)session.removeAttribute(ENCODER);
        if (encoder == null) {
            return;
        }
        try {
            encoder.dispose(session);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to dispose: " + encoder.getClass().getName() + " (" + encoder + ')');
        }
    }

    private void disposeDecoder(IoSession session) {
        ProtocolDecoder decoder = (ProtocolDecoder)session.removeAttribute(DECODER);
        if (decoder == null) {
            return;
        }
        try {
            decoder.dispose(session);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to dispose: " + decoder.getClass().getName() + " (" + decoder + ')');
        }
    }

    private static class ProtocolEncoderOutputLocal
    extends ThreadLocal<ProtocolEncoderOutputImpl> {
        private ProtocolEncoderOutputLocal() {
        }

        @Override
        protected ProtocolEncoderOutputImpl initialValue() {
            return new ProtocolEncoderOutputImpl();
        }
    }

    private static class ProtocolDecoderOutputLocal
    extends ThreadLocal<ProtocolDecoderOutputImpl> {
        private ProtocolDecoderOutputLocal() {
        }

        @Override
        protected ProtocolDecoderOutputImpl initialValue() {
            return new ProtocolDecoderOutputImpl();
        }
    }

    private static class ProtocolEncoderOutputImpl
    extends AbstractProtocolEncoderOutput {
    }

    private static class ProtocolDecoderOutputImpl
    extends AbstractProtocolDecoderOutput {
    }

    private static class EncodedWriteRequest
    extends DefaultWriteRequest {
        public EncodedWriteRequest(Object encodedMessage, WriteFuture future, SocketAddress destination) {
            super(encodedMessage, future, destination);
        }

        @Override
        public boolean isEncoded() {
            return true;
        }
    }
}

