/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client.cdi;

import jakarta.interceptor.InvocationContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.cxf.microprofile.client.cdi.InterceptorInvoker;

class MPRestClientInvocationContextImpl
implements InvocationContext {
    private final Object target;
    private final Method method;
    private Object[] args;
    private int index;
    private final List<InterceptorInvoker> interceptorInvokers;
    private final Map<String, Object> contextData = new HashMap<String, Object>();
    private final Callable<Object> callable;

    MPRestClientInvocationContextImpl(Object target, Method method, Object[] args, List<InterceptorInvoker> interceptorInvokers, Callable<Object> callable) {
        this.target = target;
        this.method = method;
        this.args = args == null ? new Object[]{} : args;
        this.interceptorInvokers = interceptorInvokers;
        this.callable = callable;
    }

    boolean hasNextInterceptor() {
        return this.index < this.interceptorInvokers.size();
    }

    protected Object invokeNextInterceptor() throws Exception {
        int oldIndex = this.index;
        try {
            Object object = this.interceptorInvokers.get(this.index++).invoke(this);
            return object;
        }
        finally {
            this.index = oldIndex;
        }
    }

    protected Object interceptorChainCompleted() throws Exception {
        return this.callable.call();
    }

    public Object proceed() throws Exception {
        if (this.hasNextInterceptor()) {
            return this.invokeNextInterceptor();
        }
        return this.interceptorChainCompleted();
    }

    public Object getTarget() {
        return this.target;
    }

    public Method getMethod() {
        return this.method;
    }

    public Constructor<?> getConstructor() {
        return null;
    }

    public Object[] getParameters() throws IllegalStateException {
        return this.args;
    }

    public void setParameters(Object[] params) throws IllegalStateException, IllegalArgumentException {
        this.args = params;
    }

    public Map<String, Object> getContextData() {
        return this.contextData;
    }

    public Object getTimer() {
        return null;
    }
}

