/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkIterativeInverseDisplacementFieldImageFilter_h
#define sitkIterativeInverseDisplacementFieldImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class IterativeInverseDisplacementFieldImageFilter
\brief Computes the inverse of a displacement field.

IterativeInverseDisplacementFieldImageFilter takes a displacement field as input and computes the displacement field that is its inverse. If the input displacement field was mapping coordinates from a space A into a space B, the output of this filter will map coordinates from the space B into the space A.

The algorithm implemented in this filter uses an iterative method for progressively refining the values of the inverse field. Starting from the direct field, at every pixel the direct mapping of this point is found, and a the negative of the current displacement is stored in the inverse field at the nearest pixel. Then, subsequent iterations verify if any of the neighbor pixels provide a better return to the current pixel, in which case its value is taken for updating the vector in the inverse field.

This method was discussed in the users-list during February 2004.

\author Corinne Mattmann
\sa itk::simple::IterativeInverseDisplacementField for the procedural interface
\sa itk::IterativeInverseDisplacementFieldImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT IterativeInverseDisplacementFieldImageFilter : public ImageFilter {
    public:
      using Self = IterativeInverseDisplacementFieldImageFilter;

      /** Destructor */
      virtual ~IterativeInverseDisplacementFieldImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      IterativeInverseDisplacementFieldImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = RealVectorPixelIDTypeList;
\

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetNumberOfIterations ( uint32_t NumberOfIterations ) { this->m_NumberOfIterations = NumberOfIterations; return *this; }

      /**
       */
      uint32_t GetNumberOfIterations() const { return this->m_NumberOfIterations; }\

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetStopValue ( double StopValue ) { this->m_StopValue = StopValue; return *this; }

      /**
       */
      double GetStopValue() const { return this->m_StopValue; }

      /** Name of this class */
      std::string GetName() const { return std::string ("IterativeInverseDisplacementFieldImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /* Number of iterations to run */
      uint32_t  m_NumberOfIterations{5u};

      /*  */
      double  m_StopValue{0.0};



    };

    /**\
     * \brief Computes the inverse of a displacement field.
     *
     * This function directly calls the execute method of IterativeInverseDisplacementFieldImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::IterativeInverseDisplacementFieldImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image IterativeInverseDisplacementField ( const Image& image1, uint32_t numberOfIterations = 5u, double stopValue = 0.0 );

     /** @} */
}
#endif
