/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkComplexToModulusImageFilter_h
#define sitkComplexToModulusImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class ComplexToModulusImageFilter
\brief Computes pixel-wise the Modulus of a complex image.


\sa itk::simple::ComplexToModulus for the procedural interface
\sa itk::ComplexToModulusImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT ComplexToModulusImageFilter : public ImageFilter {
    public:
      using Self = ComplexToModulusImageFilter;

      /** Destructor */
      virtual ~ComplexToModulusImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      ComplexToModulusImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = ComplexPixelIDTypeList;


      /** Name of this class */
      std::string GetName() const { return std::string ("ComplexToModulusImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
#ifndef SWIG
      Image Execute ( Image&& image1 );
#endif
      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;



      bool m_InPlace{false};
    };

    /**\
     * \brief Computes pixel-wise the Modulus of a complex image.
     *
     * This function directly calls the execute method of ComplexToModulusImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::ComplexToModulusImageFilter for the object oriented interface
     * @{
     */
#ifndef SWIG
     SITKBasicFilters_EXPORT Image ComplexToModulus ( Image&& image1 );
#endif
     SITKBasicFilters_EXPORT Image ComplexToModulus ( const Image& image1 );

     /** @} */
}
#endif
