/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.pdmodel.ResourceCache;
import org.apache.pdfbox.pdmodel.font.PDCIDFont;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType0;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType2;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDMMType1Font;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1CFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.PDType3Font;

public final class PDFontFactory {
    private static final Log LOG = LogFactory.getLog(PDFontFactory.class);
    private static final String FONT_TYPE1C = "Type1C";
    private static final String FONT_OPEN_TYPE = "OTTO";
    private static final String FONT_TTF_COLLECTION = "ttcf";
    private static final String FONT_TRUE_TYPE = "true";
    private static final byte[] TTF_HEADER = new byte[]{0, 1, 0, 0};

    private PDFontFactory() {
    }

    public static PDFont createFont(COSDictionary dictionary) throws IOException {
        return PDFontFactory.createFont(dictionary, null);
    }

    public static PDFont createFont(COSDictionary dictionary, ResourceCache resourceCache) throws IOException {
        COSName subType;
        COSName type = dictionary.getCOSName(COSName.TYPE, COSName.FONT);
        if (!COSName.FONT.equals(type)) {
            LOG.error((Object)("Expected 'Font' dictionary but found '" + type.getName() + "'"));
        }
        if (COSName.TYPE1.equals(subType = dictionary.getCOSName(COSName.SUBTYPE))) {
            COSDictionary fd = dictionary.getCOSDictionary(COSName.FONT_DESC);
            if (fd != null && fd.containsKey(COSName.FONT_FILE3)) {
                return new PDType1CFont(dictionary);
            }
            return new PDType1Font(dictionary);
        }
        if (COSName.MM_TYPE1.equals(subType)) {
            COSDictionary fd = dictionary.getCOSDictionary(COSName.FONT_DESC);
            if (fd != null && fd.containsKey(COSName.FONT_FILE3)) {
                return new PDType1CFont(dictionary);
            }
            return new PDMMType1Font(dictionary);
        }
        if (COSName.TRUE_TYPE.equals(subType)) {
            return new PDTrueTypeFont(dictionary);
        }
        if (COSName.TYPE3.equals(subType)) {
            return new PDType3Font(dictionary, resourceCache);
        }
        if (COSName.TYPE0.equals(subType)) {
            COSDictionary fontDescriptor = PDFontFactory.getFontDescriptor(dictionary);
            FontType fontTypeFromFont = PDFontFactory.getFontTypeFromFont(fontDescriptor, subType);
            if (fontTypeFromFont != null) {
                COSName descFontType;
                COSDictionary descendantFont = PDFontFactory.getDescendantFont(dictionary);
                COSName cOSName = descFontType = descendantFont != null ? descendantFont.getCOSName(COSName.SUBTYPE) : null;
                if (descFontType != null && !fontTypeFromFont.isCIDSubtype(descFontType)) {
                    PDFontFactory.fixType0Subtype(descendantFont, fontDescriptor, fontTypeFromFont.getSubtype());
                }
            }
            return new PDType0Font(dictionary);
        }
        if (COSName.CID_FONT_TYPE0.equals(subType)) {
            throw new IOException("Type 0 descendant font not allowed");
        }
        if (COSName.CID_FONT_TYPE2.equals(subType)) {
            throw new IOException("Type 2 descendant font not allowed");
        }
        LOG.warn((Object)("Invalid font subtype '" + subType + "'"));
        return new PDType1Font(dictionary);
    }

    private static void fixType0Subtype(COSDictionary descendantFont, COSDictionary fontDescriptor, COSName newSubType) {
        LOG.warn((Object)("Try to fix different descendant font types for font " + fontDescriptor.getNameAsString(COSName.FONT_NAME)));
        if (COSName.CID_FONT_TYPE0.equals(newSubType) && !fontDescriptor.containsKey(COSName.FONT_FILE3) && fontDescriptor.containsKey(COSName.FONT_FILE2)) {
            fontDescriptor.setItem(COSName.FONT_FILE3, fontDescriptor.getItem(COSName.FONT_FILE2));
            fontDescriptor.removeItem(COSName.FONT_FILE2);
        }
        if (COSName.CID_FONT_TYPE2.equals(newSubType) && fontDescriptor.containsKey(COSName.FONT_FILE3) && !fontDescriptor.containsKey(COSName.FONT_FILE2)) {
            fontDescriptor.setItem(COSName.FONT_FILE2, fontDescriptor.getItem(COSName.FONT_FILE3));
            fontDescriptor.removeItem(COSName.FONT_FILE3);
        }
        descendantFont.setItem(COSName.SUBTYPE, (COSBase)newSubType);
    }

    private static FontType getFontTypeFromFont(COSDictionary fontDescriptor, COSName fontType) throws IOException {
        byte[] fontHeader = PDFontFactory.getFontHeader(fontDescriptor);
        if (fontHeader == null) {
            return null;
        }
        boolean isComposite = COSName.TYPE0.equals(fontType);
        if (PDFontFactory.isTrueTypeFile(fontHeader) || PDFontFactory.isTrueTypeCollectionFile(fontHeader)) {
            return isComposite ? new FontType(COSName.TYPE0, COSName.TRUE_TYPE.getName()) : new FontType(COSName.TRUE_TYPE);
        }
        if (PDFontFactory.isOpenTypeFile(fontHeader)) {
            return isComposite ? new FontType(COSName.TYPE0, COSName.OPEN_TYPE.getName()) : new FontType(COSName.OPEN_TYPE);
        }
        if (PDFontFactory.isType1File(fontHeader) || PDFontFactory.isPfbFile(fontHeader)) {
            if (isComposite) {
                return new FontType(COSName.TYPE0, COSName.TYPE1.getName());
            }
            return fontType.equals(COSName.MM_TYPE1) ? new FontType(COSName.MM_TYPE1, COSName.TYPE1.getName()) : new FontType(COSName.TYPE1);
        }
        if (PDFontFactory.isCFFFile(fontHeader)) {
            if (isComposite) {
                return new FontType(COSName.TYPE0, FONT_TYPE1C);
            }
            return fontType.equals(COSName.MM_TYPE1) ? new FontType(COSName.MM_TYPE1, FONT_TYPE1C) : new FontType(COSName.TYPE1, FONT_TYPE1C);
        }
        return null;
    }

    private static boolean isTrueTypeFile(byte[] header) {
        return Arrays.equals(TTF_HEADER, header) || FONT_TRUE_TYPE.equals(new String(header, StandardCharsets.US_ASCII));
    }

    private static boolean isTrueTypeCollectionFile(byte[] header) {
        return FONT_TTF_COLLECTION.equals(new String(header, StandardCharsets.US_ASCII));
    }

    private static boolean isOpenTypeFile(byte[] header) {
        return FONT_OPEN_TYPE.equals(new String(header, StandardCharsets.US_ASCII));
    }

    private static boolean isType1File(byte[] header) {
        return header[0] == 37 && header[1] == 33;
    }

    private static boolean isPfbFile(byte[] header) {
        return header[0] == -128 && (header[1] == 1 || header[1] == 2);
    }

    private static boolean isCFFFile(byte[] header) {
        return header[0] >= 1 && header[3] >= 1 && header[3] <= 4;
    }

    private static COSDictionary getFontDescriptor(COSDictionary dictionary) {
        COSDictionary descendantFont;
        COSDictionary fontDescriptor = dictionary.getCOSDictionary(COSName.FONT_DESC);
        if (fontDescriptor == null && (descendantFont = PDFontFactory.getDescendantFont(dictionary)) != null) {
            fontDescriptor = descendantFont.getCOSDictionary(COSName.FONT_DESC);
        }
        return fontDescriptor;
    }

    private static COSDictionary getDescendantFont(COSDictionary dictionary) {
        COSBase descendantFontDictBase;
        COSArray descendantFonts = dictionary.getCOSArray(COSName.DESCENDANT_FONTS);
        if (descendantFonts != null && descendantFonts.size() > 0 && (descendantFontDictBase = descendantFonts.getObject(0)) instanceof COSDictionary) {
            return (COSDictionary)descendantFontDictBase;
        }
        return null;
    }

    private static byte[] getFontHeader(COSDictionary fontDescriptor) throws IOException {
        if (fontDescriptor == null) {
            return null;
        }
        COSStream fontFile = fontDescriptor.getCOSStream(COSName.FONT_FILE);
        if (fontFile == null) {
            fontFile = fontDescriptor.getCOSStream(COSName.FONT_FILE2);
        }
        if (fontFile == null) {
            fontFile = fontDescriptor.getCOSStream(COSName.FONT_FILE3);
        }
        byte[] header = null;
        if (fontFile != null) {
            try (RandomAccessRead fontView = fontFile.createView();){
                int amountRead;
                int headerLength = 4;
                header = new byte[headerLength];
                int remainingBytes = headerLength;
                while ((amountRead = fontView.read(header, headerLength - remainingBytes, remainingBytes)) > 0) {
                    remainingBytes -= amountRead;
                }
            }
            catch (IOException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return header;
    }

    static PDCIDFont createDescendantFont(COSDictionary dictionary, PDType0Font parent) throws IOException {
        COSName type = dictionary.getCOSName(COSName.TYPE, COSName.FONT);
        if (!COSName.FONT.equals(type)) {
            throw new IOException("Expected 'Font' dictionary but found '" + type.getName() + "'");
        }
        COSName subType = dictionary.getCOSName(COSName.SUBTYPE);
        if (COSName.CID_FONT_TYPE0.equals(subType)) {
            return new PDCIDFontType0(dictionary, parent);
        }
        if (COSName.CID_FONT_TYPE2.equals(subType)) {
            return new PDCIDFontType2(dictionary, parent);
        }
        throw new IOException("Invalid font type: " + type);
    }

    private static class FontType {
        private static final List<String> cidType0Types = Arrays.asList(COSName.TYPE1.getName(), "Type1C");
        private static final List<String> cidType2Types = Arrays.asList(COSName.TRUE_TYPE.getName(), COSName.OPEN_TYPE.getName());
        private final COSName type;
        private final COSName subtype;

        FontType(COSName type, String subtypeString) {
            this.type = type;
            this.subtype = cidType0Types.contains(subtypeString) ? COSName.CID_FONT_TYPE0 : (cidType2Types.contains(subtypeString) ? COSName.CID_FONT_TYPE2 : null);
        }

        FontType(COSName type, COSName subtype) {
            this.type = type;
            this.subtype = subtype;
        }

        FontType(COSName type) {
            this(type, (COSName)null);
        }

        public COSName getSubtype() {
            return this.subtype;
        }

        public boolean isCIDSubtype(COSName cidSubtype) {
            if (!COSName.TYPE0.equals(this.type)) {
                return false;
            }
            return this.subtype != null && this.subtype.equals(cidSubtype);
        }
    }
}

