/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.query.rewriters;

import java.util.List;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.query.QueryRewriter;

public class MatchAllRemovalRewriter
implements QueryRewriter {
    public static final MatchAllRemovalRewriter INSTANCE = new MatchAllRemovalRewriter();

    private MatchAllRemovalRewriter() {
    }

    @Override
    public QueryBuilder rewrite(QueryBuilder query, QueryShardContext context) {
        if (query instanceof BoolQueryBuilder) {
            return this.rewriteBoolQuery((BoolQueryBuilder)query);
        }
        return query;
    }

    private QueryBuilder rewriteBoolQuery(BoolQueryBuilder original) {
        boolean needsRewrite;
        if (original.should().isEmpty() && original.mustNot().isEmpty()) {
            boolean onlyMatchAll = true;
            int matchAllCount = 0;
            int matchAllInMust = 0;
            for (QueryBuilder q : original.must()) {
                if (q instanceof MatchAllQueryBuilder) {
                    ++matchAllCount;
                    ++matchAllInMust;
                    continue;
                }
                onlyMatchAll = false;
                break;
            }
            if (onlyMatchAll) {
                for (QueryBuilder q : original.filter()) {
                    if (q instanceof MatchAllQueryBuilder) {
                        ++matchAllCount;
                        continue;
                    }
                    onlyMatchAll = false;
                    break;
                }
            }
            if (onlyMatchAll && matchAllCount > 0 && (matchAllInMust == 0 || matchAllCount == 1)) {
                MatchAllQueryBuilder matchAll = new MatchAllQueryBuilder();
                if (original.boost() != 1.0f) {
                    matchAll.boost(original.boost());
                }
                return matchAll;
            }
        }
        if (!(needsRewrite = this.shouldRewrite(original))) {
            return original;
        }
        BoolQueryBuilder rewritten = new BoolQueryBuilder();
        rewritten.boost(original.boost());
        rewritten.queryName(original.queryName());
        rewritten.minimumShouldMatch(original.minimumShouldMatch());
        rewritten.adjustPureNegative(original.adjustPureNegative());
        this.processClausesWithContext(original.must(), rewritten::must, true, original, true);
        this.processClauses(original.filter(), rewritten::filter, true, original);
        this.processClauses(original.should(), rewritten::should, false, original);
        this.processClauses(original.mustNot(), rewritten::mustNot, false, original);
        return rewritten;
    }

    private boolean shouldRewrite(BoolQueryBuilder bool) {
        if (this.hasMatchAll(bool.must()) || this.hasMatchAll(bool.filter())) {
            return true;
        }
        return this.hasNestedBoolThatNeedsRewrite(bool);
    }

    private boolean hasMatchAll(List<QueryBuilder> clauses) {
        for (QueryBuilder q : clauses) {
            if (!(q instanceof MatchAllQueryBuilder)) continue;
            return true;
        }
        return false;
    }

    private boolean hasNestedBoolThatNeedsRewrite(BoolQueryBuilder bool) {
        for (QueryBuilder q : bool.must()) {
            if (!(q instanceof BoolQueryBuilder) || !this.shouldRewrite((BoolQueryBuilder)q)) continue;
            return true;
        }
        for (QueryBuilder q : bool.filter()) {
            if (!(q instanceof BoolQueryBuilder) || !this.shouldRewrite((BoolQueryBuilder)q)) continue;
            return true;
        }
        for (QueryBuilder q : bool.should()) {
            if (!(q instanceof BoolQueryBuilder) || !this.shouldRewrite((BoolQueryBuilder)q)) continue;
            return true;
        }
        for (QueryBuilder q : bool.mustNot()) {
            if (!(q instanceof BoolQueryBuilder) || !this.shouldRewrite((BoolQueryBuilder)q)) continue;
            return true;
        }
        return false;
    }

    private void processClausesWithContext(List<QueryBuilder> clauses, ClauseAdder adder, boolean removeMatchAll, BoolQueryBuilder original, boolean isMustClause) {
        if (!removeMatchAll) {
            this.processClauses(clauses, adder, false, original);
            return;
        }
        if (isMustClause) {
            boolean isScoringContext;
            boolean hasNonMatchAll = clauses.stream().anyMatch(q -> !(q instanceof MatchAllQueryBuilder));
            boolean bl = isScoringContext = original.filter().isEmpty() && original.should().isEmpty() && original.mustNot().isEmpty();
            if (!hasNonMatchAll || isScoringContext) {
                this.processClauses(clauses, adder, false, original);
                return;
            }
        }
        this.processClauses(clauses, adder, removeMatchAll, original);
    }

    private void processClauses(List<QueryBuilder> clauses, ClauseAdder adder, boolean removeMatchAll, BoolQueryBuilder original) {
        if (!removeMatchAll) {
            for (QueryBuilder clause : clauses) {
                if (clause instanceof BoolQueryBuilder) {
                    adder.addClause(this.rewriteBoolQuery((BoolQueryBuilder)clause));
                    continue;
                }
                adder.addClause(clause);
            }
            return;
        }
        boolean hasOtherClauses = this.hasNonMatchAllInSameList(clauses) || this.hasClausesInOtherLists(original);
        for (QueryBuilder clause : clauses) {
            if (clause instanceof BoolQueryBuilder) {
                adder.addClause(this.rewriteBoolQuery((BoolQueryBuilder)clause));
                continue;
            }
            if (clause instanceof MatchAllQueryBuilder && hasOtherClauses) continue;
            adder.addClause(clause);
        }
    }

    private boolean hasNonMatchAllInSameList(List<QueryBuilder> clauses) {
        for (QueryBuilder q : clauses) {
            if (q instanceof MatchAllQueryBuilder) continue;
            return true;
        }
        return false;
    }

    private boolean hasClausesInOtherLists(BoolQueryBuilder bool) {
        return !bool.must().isEmpty() || !bool.filter().isEmpty() || !bool.should().isEmpty() || !bool.mustNot().isEmpty();
    }

    @Override
    public int priority() {
        return 300;
    }

    @Override
    public String name() {
        return "match_all_removal";
    }

    @FunctionalInterface
    private static interface ClauseAdder {
        public void addClause(QueryBuilder var1);
    }
}

