/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway.remote;

import com.jcraft.jzlib.JZlib;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.DiffableStringMap;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.BufferedChecksumStreamOutput;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParseException;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.gateway.remote.RemoteStateTransferException;
import org.opensearch.threadpool.ThreadPool;

public class ClusterStateChecksum
implements ToXContentFragment,
Writeable {
    public static final int COMPONENT_SIZE = 11;
    static final String ROUTING_TABLE_CS = "routing_table";
    static final String NODES_CS = "discovery_nodes";
    static final String BLOCKS_CS = "blocks";
    static final String CUSTOMS_CS = "customs";
    static final String COORDINATION_MD_CS = "coordination_md";
    static final String SETTINGS_MD_CS = "settings_md";
    static final String TRANSIENT_SETTINGS_MD_CS = "transient_settings_md";
    static final String TEMPLATES_MD_CS = "templates_md";
    static final String CUSTOM_MD_CS = "customs_md";
    static final String HASHES_MD_CS = "hashes_md";
    static final String INDICES_CS = "indices_md";
    private static final String CLUSTER_STATE_CS = "cluster_state";
    private static final int CHECKSUM_SIZE = 8;
    private static final Logger logger = LogManager.getLogger(ClusterStateChecksum.class);
    long routingTableChecksum;
    long nodesChecksum;
    long blocksChecksum;
    long clusterStateCustomsChecksum;
    long coordinationMetadataChecksum;
    long settingMetadataChecksum;
    long transientSettingsMetadataChecksum;
    long templatesMetadataChecksum;
    long customMetadataMapChecksum;
    long hashesOfConsistentSettingsChecksum;
    long indicesChecksum;
    long clusterStateChecksum;

    public ClusterStateChecksum(ClusterState clusterState, ThreadPool threadpool) {
        long start = threadpool.relativeTimeInNanos();
        ExecutorService executorService = threadpool.executor("remote_state_checksum");
        CountDownLatch latch = new CountDownLatch(11);
        this.executeChecksumTask((CheckedFunction<BufferedChecksumStreamOutput, Void, IOException>)((CheckedFunction)stream -> {
            clusterState.routingTable().writeVerifiableTo((BufferedChecksumStreamOutput)stream);
            return null;
        }), checksum -> {
            this.routingTableChecksum = checksum;
        }, executorService, latch);
        this.executeChecksumTask((CheckedFunction<BufferedChecksumStreamOutput, Void, IOException>)((CheckedFunction)stream -> {
            clusterState.nodes().writeVerifiableTo((BufferedChecksumStreamOutput)stream);
            return null;
        }), checksum -> {
            this.nodesChecksum = checksum;
        }, executorService, latch);
        this.executeChecksumTask((CheckedFunction<BufferedChecksumStreamOutput, Void, IOException>)((CheckedFunction)stream -> {
            clusterState.coordinationMetadata().writeVerifiableTo((BufferedChecksumStreamOutput)stream);
            return null;
        }), checksum -> {
            this.coordinationMetadataChecksum = checksum;
        }, executorService, latch);
        this.executeChecksumTask((CheckedFunction<BufferedChecksumStreamOutput, Void, IOException>)((CheckedFunction)stream -> {
            Settings.writeSettingsToStream(clusterState.metadata().persistentSettings(), (StreamOutput)stream);
            return null;
        }), checksum -> {
            this.settingMetadataChecksum = checksum;
        }, executorService, latch);
        this.executeChecksumTask((CheckedFunction<BufferedChecksumStreamOutput, Void, IOException>)((CheckedFunction)stream -> {
            Settings.writeSettingsToStream(clusterState.metadata().transientSettings(), (StreamOutput)stream);
            return null;
        }), checksum -> {
            this.transientSettingsMetadataChecksum = checksum;
        }, executorService, latch);
        this.executeChecksumTask((CheckedFunction<BufferedChecksumStreamOutput, Void, IOException>)((CheckedFunction)stream -> {
            clusterState.metadata().templatesMetadata().writeVerifiableTo((BufferedChecksumStreamOutput)stream);
            return null;
        }), checksum -> {
            this.templatesMetadataChecksum = checksum;
        }, executorService, latch);
        this.executeChecksumTask((CheckedFunction<BufferedChecksumStreamOutput, Void, IOException>)((CheckedFunction)stream -> {
            stream.writeStringCollection(clusterState.metadata().customs().keySet());
            return null;
        }), checksum -> {
            this.customMetadataMapChecksum = checksum;
        }, executorService, latch);
        this.executeChecksumTask((CheckedFunction<BufferedChecksumStreamOutput, Void, IOException>)((CheckedFunction)stream -> {
            ((DiffableStringMap)clusterState.metadata().hashesOfConsistentSettings()).writeTo((StreamOutput)stream);
            return null;
        }), checksum -> {
            this.hashesOfConsistentSettingsChecksum = checksum;
        }, executorService, latch);
        this.executeChecksumTask((CheckedFunction<BufferedChecksumStreamOutput, Void, IOException>)((CheckedFunction)stream -> {
            stream.writeMapValues(clusterState.metadata().indices(), (checksumStream, value) -> value.writeVerifiableTo((BufferedChecksumStreamOutput)checksumStream));
            return null;
        }), checksum -> {
            this.indicesChecksum = checksum;
        }, executorService, latch);
        this.executeChecksumTask((CheckedFunction<BufferedChecksumStreamOutput, Void, IOException>)((CheckedFunction)stream -> {
            clusterState.blocks().writeVerifiableTo((BufferedChecksumStreamOutput)stream);
            return null;
        }), checksum -> {
            this.blocksChecksum = checksum;
        }, executorService, latch);
        this.executeChecksumTask((CheckedFunction<BufferedChecksumStreamOutput, Void, IOException>)((CheckedFunction)stream -> {
            stream.writeStringCollection(clusterState.customs().keySet());
            return null;
        }), checksum -> {
            this.clusterStateCustomsChecksum = checksum;
        }, executorService, latch);
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RemoteStateTransferException("Failed to create checksum for cluster state.", e);
        }
        this.createClusterStateChecksum();
        logger.debug("Checksum execution time {}", (Object)TimeValue.nsecToMSec((long)(threadpool.relativeTimeInNanos() - start)));
    }

    private void executeChecksumTask(CheckedFunction<BufferedChecksumStreamOutput, Void, IOException> checksumTask, Consumer<Long> checksumConsumer, ExecutorService executorService, CountDownLatch latch) {
        executorService.execute(() -> {
            try {
                long checksum = this.createChecksum(checksumTask);
                checksumConsumer.accept(checksum);
                latch.countDown();
            }
            catch (IOException e) {
                throw new RemoteStateTransferException("Failed to execute checksum task", e);
            }
        });
    }

    private long createChecksum(CheckedFunction<BufferedChecksumStreamOutput, Void, IOException> task) throws IOException {
        try (BytesStreamOutput out = new BytesStreamOutput();){
            long l;
            try (BufferedChecksumStreamOutput checksumOut = new BufferedChecksumStreamOutput((StreamOutput)out);){
                task.apply((Object)checksumOut);
                l = checksumOut.getChecksum();
            }
            return l;
        }
    }

    private void createClusterStateChecksum() {
        this.clusterStateChecksum = JZlib.crc32_combine((long)this.routingTableChecksum, (long)this.nodesChecksum, (long)8L);
        this.clusterStateChecksum = JZlib.crc32_combine((long)this.clusterStateChecksum, (long)this.blocksChecksum, (long)8L);
        this.clusterStateChecksum = JZlib.crc32_combine((long)this.clusterStateChecksum, (long)this.clusterStateCustomsChecksum, (long)8L);
        this.clusterStateChecksum = JZlib.crc32_combine((long)this.clusterStateChecksum, (long)this.coordinationMetadataChecksum, (long)8L);
        this.clusterStateChecksum = JZlib.crc32_combine((long)this.clusterStateChecksum, (long)this.settingMetadataChecksum, (long)8L);
        this.clusterStateChecksum = JZlib.crc32_combine((long)this.clusterStateChecksum, (long)this.transientSettingsMetadataChecksum, (long)8L);
        this.clusterStateChecksum = JZlib.crc32_combine((long)this.clusterStateChecksum, (long)this.templatesMetadataChecksum, (long)8L);
        this.clusterStateChecksum = JZlib.crc32_combine((long)this.clusterStateChecksum, (long)this.customMetadataMapChecksum, (long)8L);
        this.clusterStateChecksum = JZlib.crc32_combine((long)this.clusterStateChecksum, (long)this.hashesOfConsistentSettingsChecksum, (long)8L);
        this.clusterStateChecksum = JZlib.crc32_combine((long)this.clusterStateChecksum, (long)this.indicesChecksum, (long)8L);
    }

    public static Builder builder() {
        return new Builder();
    }

    public ClusterStateChecksum(long routingTableChecksum, long nodesChecksum, long blocksChecksum, long clusterStateCustomsChecksum, long coordinationMetadataChecksum, long settingMetadataChecksum, long transientSettingsMetadataChecksum, long templatesMetadataChecksum, long customMetadataMapChecksum, long hashesOfConsistentSettingsChecksum, long indicesChecksum, long clusterStateChecksum) {
        this.routingTableChecksum = routingTableChecksum;
        this.nodesChecksum = nodesChecksum;
        this.blocksChecksum = blocksChecksum;
        this.clusterStateCustomsChecksum = clusterStateCustomsChecksum;
        this.coordinationMetadataChecksum = coordinationMetadataChecksum;
        this.settingMetadataChecksum = settingMetadataChecksum;
        this.transientSettingsMetadataChecksum = transientSettingsMetadataChecksum;
        this.templatesMetadataChecksum = templatesMetadataChecksum;
        this.customMetadataMapChecksum = customMetadataMapChecksum;
        this.hashesOfConsistentSettingsChecksum = hashesOfConsistentSettingsChecksum;
        this.indicesChecksum = indicesChecksum;
        this.clusterStateChecksum = clusterStateChecksum;
    }

    public ClusterStateChecksum(StreamInput in) throws IOException {
        this.routingTableChecksum = in.readLong();
        this.nodesChecksum = in.readLong();
        this.blocksChecksum = in.readLong();
        this.clusterStateCustomsChecksum = in.readLong();
        this.coordinationMetadataChecksum = in.readLong();
        this.settingMetadataChecksum = in.readLong();
        this.transientSettingsMetadataChecksum = in.readLong();
        this.templatesMetadataChecksum = in.readLong();
        this.customMetadataMapChecksum = in.readLong();
        this.hashesOfConsistentSettingsChecksum = in.readLong();
        this.indicesChecksum = in.readLong();
        this.clusterStateChecksum = in.readLong();
    }

    public static ClusterStateChecksum fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        Builder builder = new Builder();
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            parser.nextToken();
        }
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        String currentFieldName = parser.currentName();
        block28: while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (parser.currentToken() == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                switch (currentFieldName) {
                    case "routing_table": {
                        builder.routingTableChecksum(parser.longValue());
                        continue block28;
                    }
                    case "discovery_nodes": {
                        builder.nodesChecksum(parser.longValue());
                        continue block28;
                    }
                    case "blocks": {
                        builder.blocksChecksum(parser.longValue());
                        continue block28;
                    }
                    case "customs": {
                        builder.clusterStateCustomsChecksum(parser.longValue());
                        continue block28;
                    }
                    case "coordination_md": {
                        builder.coordinationMetadataChecksum(parser.longValue());
                        continue block28;
                    }
                    case "settings_md": {
                        builder.settingMetadataChecksum(parser.longValue());
                        continue block28;
                    }
                    case "transient_settings_md": {
                        builder.transientSettingsMetadataChecksum(parser.longValue());
                        continue block28;
                    }
                    case "templates_md": {
                        builder.templatesMetadataChecksum(parser.longValue());
                        continue block28;
                    }
                    case "customs_md": {
                        builder.customMetadataMapChecksum(parser.longValue());
                        continue block28;
                    }
                    case "hashes_md": {
                        builder.hashesOfConsistentSettingsChecksum(parser.longValue());
                        continue block28;
                    }
                    case "indices_md": {
                        builder.indicesChecksum(parser.longValue());
                        continue block28;
                    }
                    case "cluster_state": {
                        builder.clusterStateChecksum(parser.longValue());
                        continue block28;
                    }
                }
                throw new XContentParseException("Unexpected field [" + currentFieldName + "]");
            }
            throw new XContentParseException("Unexpected token [" + String.valueOf(token) + "]");
        }
        return builder.build();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.routingTableChecksum);
        out.writeLong(this.nodesChecksum);
        out.writeLong(this.blocksChecksum);
        out.writeLong(this.clusterStateCustomsChecksum);
        out.writeLong(this.coordinationMetadataChecksum);
        out.writeLong(this.settingMetadataChecksum);
        out.writeLong(this.transientSettingsMetadataChecksum);
        out.writeLong(this.templatesMetadataChecksum);
        out.writeLong(this.customMetadataMapChecksum);
        out.writeLong(this.hashesOfConsistentSettingsChecksum);
        out.writeLong(this.indicesChecksum);
        out.writeLong(this.clusterStateChecksum);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(ROUTING_TABLE_CS, this.routingTableChecksum);
        builder.field(NODES_CS, this.nodesChecksum);
        builder.field(BLOCKS_CS, this.blocksChecksum);
        builder.field(CUSTOMS_CS, this.clusterStateCustomsChecksum);
        builder.field(COORDINATION_MD_CS, this.coordinationMetadataChecksum);
        builder.field(SETTINGS_MD_CS, this.settingMetadataChecksum);
        builder.field(TRANSIENT_SETTINGS_MD_CS, this.transientSettingsMetadataChecksum);
        builder.field(TEMPLATES_MD_CS, this.templatesMetadataChecksum);
        builder.field(CUSTOM_MD_CS, this.customMetadataMapChecksum);
        builder.field(HASHES_MD_CS, this.hashesOfConsistentSettingsChecksum);
        builder.field(INDICES_CS, this.indicesChecksum);
        builder.field(CLUSTER_STATE_CS, this.clusterStateChecksum);
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterStateChecksum that = (ClusterStateChecksum)o;
        return this.routingTableChecksum == that.routingTableChecksum && this.nodesChecksum == that.nodesChecksum && this.blocksChecksum == that.blocksChecksum && this.clusterStateCustomsChecksum == that.clusterStateCustomsChecksum && this.coordinationMetadataChecksum == that.coordinationMetadataChecksum && this.settingMetadataChecksum == that.settingMetadataChecksum && this.transientSettingsMetadataChecksum == that.transientSettingsMetadataChecksum && this.templatesMetadataChecksum == that.templatesMetadataChecksum && this.customMetadataMapChecksum == that.customMetadataMapChecksum && this.hashesOfConsistentSettingsChecksum == that.hashesOfConsistentSettingsChecksum && this.indicesChecksum == that.indicesChecksum && this.clusterStateChecksum == that.clusterStateChecksum;
    }

    public int hashCode() {
        return Objects.hash(this.routingTableChecksum, this.nodesChecksum, this.blocksChecksum, this.clusterStateCustomsChecksum, this.coordinationMetadataChecksum, this.settingMetadataChecksum, this.transientSettingsMetadataChecksum, this.templatesMetadataChecksum, this.customMetadataMapChecksum, this.hashesOfConsistentSettingsChecksum, this.indicesChecksum, this.clusterStateChecksum);
    }

    public String toString() {
        return "ClusterStateChecksum{routingTableChecksum=" + this.routingTableChecksum + ", nodesChecksum=" + this.nodesChecksum + ", blocksChecksum=" + this.blocksChecksum + ", clusterStateCustomsChecksum=" + this.clusterStateCustomsChecksum + ", coordinationMetadataChecksum=" + this.coordinationMetadataChecksum + ", settingMetadataChecksum=" + this.settingMetadataChecksum + ", transientSettingsMetadataChecksum=" + this.transientSettingsMetadataChecksum + ", templatesMetadataChecksum=" + this.templatesMetadataChecksum + ", customMetadataMapChecksum=" + this.customMetadataMapChecksum + ", hashesOfConsistentSettingsChecksum=" + this.hashesOfConsistentSettingsChecksum + ", indicesChecksum=" + this.indicesChecksum + ", clusterStateChecksum=" + this.clusterStateChecksum + "}";
    }

    public List<String> getMismatchEntities(ClusterStateChecksum otherClusterStateChecksum) {
        if (this.clusterStateChecksum == otherClusterStateChecksum.clusterStateChecksum) {
            logger.debug("No mismatch in checksums.");
            return List.of();
        }
        ArrayList<String> mismatches = new ArrayList<String>();
        this.addIfMismatch(this.routingTableChecksum, otherClusterStateChecksum.routingTableChecksum, ROUTING_TABLE_CS, mismatches);
        this.addIfMismatch(this.nodesChecksum, otherClusterStateChecksum.nodesChecksum, NODES_CS, mismatches);
        this.addIfMismatch(this.blocksChecksum, otherClusterStateChecksum.blocksChecksum, BLOCKS_CS, mismatches);
        this.addIfMismatch(this.clusterStateCustomsChecksum, otherClusterStateChecksum.clusterStateCustomsChecksum, CUSTOMS_CS, mismatches);
        this.addIfMismatch(this.coordinationMetadataChecksum, otherClusterStateChecksum.coordinationMetadataChecksum, COORDINATION_MD_CS, mismatches);
        this.addIfMismatch(this.settingMetadataChecksum, otherClusterStateChecksum.settingMetadataChecksum, SETTINGS_MD_CS, mismatches);
        this.addIfMismatch(this.transientSettingsMetadataChecksum, otherClusterStateChecksum.transientSettingsMetadataChecksum, TRANSIENT_SETTINGS_MD_CS, mismatches);
        this.addIfMismatch(this.templatesMetadataChecksum, otherClusterStateChecksum.templatesMetadataChecksum, TEMPLATES_MD_CS, mismatches);
        this.addIfMismatch(this.customMetadataMapChecksum, otherClusterStateChecksum.customMetadataMapChecksum, CUSTOM_MD_CS, mismatches);
        this.addIfMismatch(this.hashesOfConsistentSettingsChecksum, otherClusterStateChecksum.hashesOfConsistentSettingsChecksum, HASHES_MD_CS, mismatches);
        this.addIfMismatch(this.indicesChecksum, otherClusterStateChecksum.indicesChecksum, INDICES_CS, mismatches);
        return mismatches;
    }

    private void addIfMismatch(long checksum, long otherChecksum, String entityName, List<String> mismatches) {
        if (checksum != otherChecksum) {
            mismatches.add(entityName);
        }
    }

    public static class Builder {
        long routingTableChecksum;
        long nodesChecksum;
        long blocksChecksum;
        long clusterStateCustomsChecksum;
        long coordinationMetadataChecksum;
        long settingMetadataChecksum;
        long transientSettingsMetadataChecksum;
        long templatesMetadataChecksum;
        long customMetadataMapChecksum;
        long hashesOfConsistentSettingsChecksum;
        long indicesChecksum;
        long clusterStateChecksum;

        public Builder routingTableChecksum(long routingTableChecksum) {
            this.routingTableChecksum = routingTableChecksum;
            return this;
        }

        public Builder nodesChecksum(long nodesChecksum) {
            this.nodesChecksum = nodesChecksum;
            return this;
        }

        public Builder blocksChecksum(long blocksChecksum) {
            this.blocksChecksum = blocksChecksum;
            return this;
        }

        public Builder clusterStateCustomsChecksum(long clusterStateCustomsChecksum) {
            this.clusterStateCustomsChecksum = clusterStateCustomsChecksum;
            return this;
        }

        public Builder coordinationMetadataChecksum(long coordinationMetadataChecksum) {
            this.coordinationMetadataChecksum = coordinationMetadataChecksum;
            return this;
        }

        public Builder settingMetadataChecksum(long settingMetadataChecksum) {
            this.settingMetadataChecksum = settingMetadataChecksum;
            return this;
        }

        public Builder transientSettingsMetadataChecksum(long transientSettingsMetadataChecksum) {
            this.transientSettingsMetadataChecksum = transientSettingsMetadataChecksum;
            return this;
        }

        public Builder templatesMetadataChecksum(long templatesMetadataChecksum) {
            this.templatesMetadataChecksum = templatesMetadataChecksum;
            return this;
        }

        public Builder customMetadataMapChecksum(long customMetadataMapChecksum) {
            this.customMetadataMapChecksum = customMetadataMapChecksum;
            return this;
        }

        public Builder hashesOfConsistentSettingsChecksum(long hashesOfConsistentSettingsChecksum) {
            this.hashesOfConsistentSettingsChecksum = hashesOfConsistentSettingsChecksum;
            return this;
        }

        public Builder indicesChecksum(long indicesChecksum) {
            this.indicesChecksum = indicesChecksum;
            return this;
        }

        public Builder clusterStateChecksum(long clusterStateChecksum) {
            this.clusterStateChecksum = clusterStateChecksum;
            return this;
        }

        public ClusterStateChecksum build() {
            return new ClusterStateChecksum(this.routingTableChecksum, this.nodesChecksum, this.blocksChecksum, this.clusterStateCustomsChecksum, this.coordinationMetadataChecksum, this.settingMetadataChecksum, this.transientSettingsMetadataChecksum, this.templatesMetadataChecksum, this.customMetadataMapChecksum, this.hashesOfConsistentSettingsChecksum, this.indicesChecksum, this.clusterStateChecksum);
        }
    }
}

