/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.maven3;

import com.intellij.maven.server.telemetry.MavenServerTelemetryClasspathUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.MavenVersionAwareSupportExtension;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.BundledMaven3;
import org.jetbrains.idea.maven.project.StaticResolvedMavenHomeType;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesCommunityRoot;
import org.jetbrains.intellij.build.impl.BundledMavenDownloader;

public class Maven3Support
implements MavenVersionAwareSupportExtension {
    @NonNls
    private static final String MAIN_CLASS36 = "org.jetbrains.idea.maven.server.RemoteMavenServer36";

    @Override
    public boolean isSupportedByExtension(@Nullable File mavenHome) {
        String version = MavenUtil.getMavenVersion(mavenHome.toPath());
        return StringUtil.compareVersionNumbers((String)version, (String)"3.1") >= 0 && StringUtil.compareVersionNumbers((String)version, (String)"4") < 0;
    }

    @Override
    @Nullable
    public Path getMavenHomeFile(@Nullable StaticResolvedMavenHomeType mavenHomeType) {
        if (mavenHomeType == null) {
            return null;
        }
        if (mavenHomeType == BundledMaven3.INSTANCE) {
            return MavenDistributionsCache.resolveEmbeddedMavenHome().getMavenHome();
        }
        return null;
    }

    @Override
    @NotNull
    public List<Path> collectClassPathAndLibsFolder(@NotNull MavenDistribution distribution) {
        if (distribution == null) {
            Maven3Support.$$$reportNull$$$0(0);
        }
        Path pluginFileOrDir = Path.of(PathUtil.getJarPathForClass(MavenServerManager.class), new String[0]);
        ArrayList<Path> classpath = new ArrayList<Path>();
        if (MavenUtil.isRunningFromSources()) {
            MavenLog.LOG.debug("collecting classpath for local run");
            Maven3Support.prepareClassPathForLocalRunAndUnitTests(distribution.getVersion(), classpath);
        } else {
            MavenLog.LOG.debug("collecting classpath for production");
            Maven3Support.prepareClassPathForProduction(distribution.getVersion(), classpath, pluginFileOrDir.getParent());
        }
        Maven3Support.addMavenLibs(classpath, distribution.getMavenHome());
        MavenLog.LOG.debug("Collected classpath = ", new Object[]{classpath});
        ArrayList<Path> arrayList = classpath;
        if (arrayList == null) {
            Maven3Support.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static void prepareClassPathForProduction(@NotNull String mavenVersion, List<Path> classpath, Path rootPath) {
        if (mavenVersion == null) {
            Maven3Support.$$$reportNull$$$0(2);
        }
        classpath.add(PathManager.getJarForClass(MavenId.class));
        classpath.add(rootPath.resolve("maven-server.jar"));
        classpath.add(rootPath.resolve("maven-server-telemetry.jar"));
        try {
            classpath.add(PathManager.getJarForClass(Class.forName("io.opentelemetry.sdk.trace.export.SpanExporter")));
        }
        catch (ClassNotFoundException e) {
            MavenLog.LOG.error((Throwable)e);
        }
        Maven3Support.addDir(classpath, rootPath.resolve("maven-telemetry-lib"), f -> true);
        classpath.add(rootPath.resolve("maven3-server-common.jar"));
        Maven3Support.addDir(classpath, rootPath.resolve("maven3-server-lib"), f -> true);
        classpath.add(rootPath.resolve("maven3-server.jar"));
        if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.6") >= 0) {
            classpath.add(rootPath.resolve("maven36-server.jar"));
        }
    }

    private static void prepareClassPathForLocalRunAndUnitTests(@NotNull String mavenVersion, List<Path> classpath) {
        if (mavenVersion == null) {
            Maven3Support.$$$reportNull$$$0(3);
        }
        BuildDependenciesCommunityRoot communityRoot = new BuildDependenciesCommunityRoot(Path.of(PathManager.getCommunityHomePath(), new String[0]));
        BundledMavenDownloader.INSTANCE.downloadMaven3LibsSync(communityRoot);
        classpath.add(PathManager.getJarForClass(MavenId.class));
        classpath.add(MavenUtil.locateModuleOutput("intellij.maven.server"));
        classpath.add(MavenUtil.locateModuleOutput("intellij.maven.server.telemetry"));
        classpath.addAll(MavenUtil.collectClasspath(MavenServerTelemetryClasspathUtil.TELEMETRY_CLASSES));
        Path parentFile = MavenUtil.getMavenPluginParentFile();
        classpath.add(MavenUtil.locateModuleOutput("intellij.maven.server.m3.common"));
        Maven3Support.addDir(classpath, parentFile.resolve("maven3-server-common/lib"), f -> true);
        classpath.add(MavenUtil.locateModuleOutput("intellij.maven.server.m3.impl"));
        if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.6") >= 0) {
            classpath.add(MavenUtil.locateModuleOutput("intellij.maven.server.m36.impl"));
        }
    }

    private static void addMavenLibs(List<Path> classpath, Path mavenHome) {
        Maven3Support.addDir(classpath, mavenHome.resolve("lib"), f -> !f.getFileName().toString().contains("maven-slf4j-provider"));
        Path bootFolder = mavenHome.resolve("boot");
        List<Path> classworldsJars = NioFiles.list((Path)bootFolder).stream().filter(f -> StringUtil.contains((CharSequence)f.getFileName().toString(), (CharSequence)"classworlds")).toList();
        classpath.addAll(classworldsJars);
    }

    private static void addDir(List<Path> classpath, Path dir, Predicate<Path> filter) {
        List files2 = NioFiles.list((Path)dir);
        for (Path jar : files2) {
            if (!Files.isRegularFile(jar, new LinkOption[0]) || !jar.getFileName().toString().endsWith(".jar") || !filter.test(jar)) continue;
            classpath.add(jar);
        }
    }

    @Override
    public String getMainClass(MavenDistribution distribution) {
        if (StringUtil.compareVersionNumbers((String)distribution.getVersion(), (String)"3.6") >= 0) {
            return MAIN_CLASS36;
        }
        return "org.jetbrains.idea.maven.server.RemoteMavenServer";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/maven3/Maven3Support";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/maven3/Maven3Support";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectClassPathAndLibsFolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectClassPathAndLibsFolder";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "prepareClassPathForProduction";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareClassPathForLocalRunAndUnitTests";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

