/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.edge.mindmapmode;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import org.freeplane.api.Dash;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.JRestrictedSizeScrollPane;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.util.ObjectRule;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.edge.EdgeColorConfiguration;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.edge.EdgeModel;
import org.freeplane.features.edge.EdgeStyle;
import org.freeplane.features.edge.mindmapmode.ColorListEditorPanelBuilder;
import org.freeplane.features.edge.mindmapmode.EdgeColorAction;
import org.freeplane.features.edge.mindmapmode.EdgeStyleAction;
import org.freeplane.features.edge.mindmapmode.EdgeStyleAsParentAction;
import org.freeplane.features.edge.mindmapmode.EdgeWidthAction;
import org.freeplane.features.map.IExtensionCopier;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.LogicalStyleKeys;

public class MEdgeController
extends EdgeController {
    public MEdgeController(ModeController modeController) {
        super(modeController);
        modeController.registerExtensionCopier((IExtensionCopier)new ExtensionCopier(modeController));
        modeController.addAction((AFreeplaneAction)new EdgeColorAction());
        modeController.addAction((AFreeplaneAction)new EdgeWidthAction(-1));
        modeController.addAction((AFreeplaneAction)new EdgeWidthAction(0));
        modeController.addAction((AFreeplaneAction)new EdgeWidthAction(1));
        modeController.addAction((AFreeplaneAction)new EdgeWidthAction(2));
        modeController.addAction((AFreeplaneAction)new EdgeWidthAction(4));
        modeController.addAction((AFreeplaneAction)new EdgeWidthAction(8));
        modeController.addAction((AFreeplaneAction)new EdgeStyleAction(EdgeStyle.EDGESTYLE_LINEAR));
        modeController.addAction((AFreeplaneAction)new EdgeStyleAction(EdgeStyle.EDGESTYLE_BEZIER));
        modeController.addAction((AFreeplaneAction)new EdgeStyleAction(EdgeStyle.EDGESTYLE_SHARP_LINEAR));
        modeController.addAction((AFreeplaneAction)new EdgeStyleAction(EdgeStyle.EDGESTYLE_SHARP_BEZIER));
        modeController.addAction((AFreeplaneAction)new EdgeStyleAction(EdgeStyle.EDGESTYLE_HORIZONTAL));
        modeController.addAction((AFreeplaneAction)new EdgeStyleAction(EdgeStyle.EDGESTYLE_HIDDEN));
        modeController.addAction((AFreeplaneAction)new EdgeStyleAsParentAction());
    }

    public void setColor(final NodeModel node, final Color color) {
        final ModeController modeController = Controller.getCurrentModeController();
        final Color oldColor = EdgeModel.createEdgeModel((NodeModel)node).getColor();
        if (color == oldColor || color != null && color.equals(oldColor)) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                EdgeModel.createEdgeModel((NodeModel)node).setColor(color);
                modeController.getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setColor";
            }

            public void undo() {
                EdgeModel.createEdgeModel((NodeModel)node).setColor(oldColor);
                modeController.getMapController().nodeChanged(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setStyle(final NodeModel node, final EdgeStyle style) {
        EdgeStyle oldStyle;
        final ModeController modeController = Controller.getCurrentModeController();
        if (style != null ? style.equals((Object)(oldStyle = EdgeModel.createEdgeModel((NodeModel)node).getStyle())) : (oldStyle = EdgeModel.createEdgeModel((NodeModel)node).getStyle()) == null) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                EdgeModel.createEdgeModel((NodeModel)node).setStyle(style);
                modeController.getMapController().nodeChanged(node);
                this.edgeStyleRefresh(node);
            }

            private void edgeStyleRefresh(NodeModel node2) {
                for (NodeModel child : node2.getChildren()) {
                    EdgeModel edge;
                    if (child.getViewers().isEmpty() || (edge = EdgeModel.getModel((NodeModel)child)) != null && edge.getStyle() != null) continue;
                    modeController.getMapController().nodeRefresh(child);
                    this.edgeStyleRefresh(child);
                }
            }

            public String getDescription() {
                return "setStyle";
            }

            public void undo() {
                EdgeModel.createEdgeModel((NodeModel)node).setStyle(oldStyle);
                modeController.getMapController().nodeChanged(node);
                this.edgeStyleRefresh(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setWidth(final NodeModel node, final int width) {
        final ModeController modeController = Controller.getCurrentModeController();
        final int oldWidth = EdgeModel.createEdgeModel((NodeModel)node).getWidth();
        if (width == oldWidth) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                EdgeModel.createEdgeModel((NodeModel)node).setWidth(width);
                modeController.getMapController().nodeChanged(node);
                this.edgeWidthRefresh(node);
            }

            private void edgeWidthRefresh(NodeModel node2) {
                for (NodeModel child : node2.getChildren()) {
                    EdgeModel edge;
                    if (child.getViewers().isEmpty() || (edge = EdgeModel.getModel((NodeModel)child)) != null && edge.getWidth() != -1) continue;
                    modeController.getMapController().nodeRefresh(child);
                    this.edgeWidthRefresh(child);
                }
            }

            public String getDescription() {
                return "setWidth";
            }

            public void undo() {
                EdgeModel.createEdgeModel((NodeModel)node).setWidth(oldWidth);
                modeController.getMapController().nodeChanged(node);
                this.edgeWidthRefresh(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setDash(final NodeModel node, final Dash dash) {
        final ModeController modeController = Controller.getCurrentModeController();
        final Dash oldDash = EdgeModel.createEdgeModel((NodeModel)node).getDash();
        if (dash == oldDash) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                EdgeModel.createEdgeModel((NodeModel)node).setDash(dash);
                modeController.getMapController().nodeChanged(node);
                this.edgeWidthRefresh(node);
            }

            private void edgeWidthRefresh(NodeModel node2) {
                for (NodeModel child : node2.getChildren()) {
                    EdgeModel edge;
                    if (child.getViewers().isEmpty() || (edge = EdgeModel.getModel((NodeModel)child)) != null && edge.getWidth() != -1) continue;
                    modeController.getMapController().nodeRefresh(child);
                    this.edgeWidthRefresh(child);
                }
            }

            public String getDescription() {
                return "setDash";
            }

            public void undo() {
                EdgeModel.createEdgeModel((NodeModel)node).setDash(oldDash);
                modeController.getMapController().nodeChanged(node);
                this.edgeWidthRefresh(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void editEdgeColorConfiguration(MapModel map) {
        List oldColors = this.edgeColorsConfigurationFactory.create((MapModel)map).colors;
        ColorListEditorPanelBuilder colorListEditorPanelBuilder = new ColorListEditorPanelBuilder(oldColors);
        JComponent panel = colorListEditorPanelBuilder.getPanel();
        JRestrictedSizeScrollPane jscrollpane = new JRestrictedSizeScrollPane((Component)panel);
        UITools.setScrollbarIncrement((JScrollPane)jscrollpane);
        jscrollpane.setVerticalScrollBarPolicy(22);
        jscrollpane.setHorizontalScrollBarPolicy(31);
        jscrollpane.setMaximumSize(new Dimension(Integer.MAX_VALUE, 600));
        String title = TextUtils.getText((String)"editEdgeColors");
        int status = JOptionPane.showConfirmDialog(UITools.getCurrentFrame(), jscrollpane, title, 2, -1);
        switch (status) {
            case 0: {
                List<Color> newColors = colorListEditorPanelBuilder.getColors();
                this.edgeColorsConfigurationFactory.setConfiguration(map, new EdgeColorConfiguration(newColors));
                break;
            }
        }
    }

    private static class ExtensionCopier
    implements IExtensionCopier {
        private final ModeController modeController;

        public ExtensionCopier(ModeController modeController) {
            this.modeController = modeController;
        }

        public void copy(Object key, NodeModel from, NodeModel to) {
            if (!key.equals(LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            this.copy(from, to);
        }

        public void copy(NodeModel from, NodeModel to) {
            Dash dash;
            int width;
            EdgeStyle style;
            EdgeModel fromStyle = (EdgeModel)from.getExtension(EdgeModel.class);
            if (fromStyle == null) {
                return;
            }
            EdgeModel toStyle = EdgeModel.createEdgeModel((NodeModel)to);
            Color color = fromStyle.getColor();
            if (color != null) {
                toStyle.setColor(color);
            }
            if ((style = fromStyle.getStyle()) != null) {
                toStyle.setStyle(style);
            }
            if ((width = fromStyle.getWidth()) != -1) {
                toStyle.setWidth(width);
            }
            if ((dash = fromStyle.getDash()) != null) {
                toStyle.setDash(dash);
            }
        }

        public void remove(Object key, NodeModel from) {
            if (!key.equals(LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            from.removeExtension(EdgeModel.class);
        }

        public void remove(Object key, NodeModel from, NodeModel which) {
            int width;
            EdgeStyle style;
            if (!key.equals(LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            EdgeModel whichStyle = (EdgeModel)which.getExtension(EdgeModel.class);
            if (whichStyle == null) {
                return;
            }
            EdgeModel fromStyle = (EdgeModel)from.getExtension(EdgeModel.class);
            if (fromStyle == null) {
                return;
            }
            from.removeExtension((IExtension)fromStyle);
            EdgeModel delta = new EdgeModel();
            Color color = fromStyle.getColor();
            boolean deltaFound = false;
            if (color != null && whichStyle.getColor() == null) {
                delta.setColor(color);
                deltaFound = true;
            }
            if ((style = fromStyle.getStyle()) != null && whichStyle.getStyle() == null) {
                delta.setStyle(style);
                deltaFound = true;
            }
            if ((width = fromStyle.getWidth()) != -1 && whichStyle.getWidth() == -1) {
                delta.setWidth(width);
                deltaFound = true;
            }
            if (deltaFound) {
                from.addExtension((IExtension)delta);
            }
        }

        public void resolveParentExtensions(Object key, NodeModel to) {
            if (!key.equals(LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            this.resolveColor(to);
            this.resolveWidth(to);
            this.resolveDash(to);
            this.resolveStyle(to);
        }

        private void resolveColor(NodeModel to) {
            if (this.getColorRule(to).hasValue()) {
                return;
            }
            for (NodeModel source = to.getParentNode(); source != null; source = source.getParentNode()) {
                ObjectRule<Color, EdgeController.Rules> colorRule = this.getColorRule(source);
                if (!colorRule.hasValue()) continue;
                EdgeModel.createEdgeModel((NodeModel)to).setColor((Color)colorRule.getValue());
                return;
            }
        }

        private ObjectRule<Color, EdgeController.Rules> getColorRule(NodeModel node) {
            return ((EdgeController)this.modeController.getExtension(EdgeController.class)).getColorRule(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        }

        private void resolveWidth(NodeModel to) {
            if (null != this.getWidth(to)) {
                return;
            }
            for (NodeModel source = to.getParentNode(); source != null; source = source.getParentNode()) {
                Integer width = this.getWidth(source);
                if (width == null) continue;
                EdgeModel.createEdgeModel((NodeModel)to).setWidth(width.intValue());
                return;
            }
        }

        private Integer getWidth(NodeModel node) {
            return ((EdgeController)this.modeController.getExtension(EdgeController.class)).getWidth(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE, false);
        }

        private void resolveDash(NodeModel to) {
            if (null != this.getDash(to)) {
                return;
            }
            for (NodeModel source = to.getParentNode(); source != null; source = source.getParentNode()) {
                Dash dash = this.getDash(source);
                if (dash == null) continue;
                EdgeModel.createEdgeModel((NodeModel)to).setDash(dash);
                return;
            }
        }

        private Dash getDash(NodeModel node) {
            return ((EdgeController)this.modeController.getExtension(EdgeController.class)).getDash(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE, false);
        }

        private void resolveStyle(NodeModel to) {
            if (null != this.getStyle(to)) {
                return;
            }
            for (NodeModel source = to.getParentNode(); source != null; source = source.getParentNode()) {
                EdgeStyle style = this.getStyle(source);
                if (style == null) continue;
                EdgeModel.createEdgeModel((NodeModel)to).setStyle(style);
                return;
            }
        }

        private EdgeStyle getStyle(NodeModel node) {
            return ((EdgeController)this.modeController.getExtension(EdgeController.class)).getStyle(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE, false);
        }
    }
}

