/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.icon.Tag;
import org.freeplane.features.icon.TagReference;
import org.freeplane.features.map.NodeModel;

public class Tags
implements IExtension {
    private List<TagReference> tags;

    private Tags(List<TagReference> tags) {
        this.tags = tags;
    }

    static List<TagReference> getTagReferences(NodeModel node) {
        Tags tags = node.getExtension(Tags.class);
        return tags == null ? Collections.emptyList() : tags.tags;
    }

    public static void setTagReferences(NodeModel node, List<TagReference> newTags) {
        Tags extension = node.getExtension(Tags.class);
        if (extension == null) {
            extension = new Tags(newTags);
            node.addExtension(extension);
        } else {
            extension.tags = newTags;
        }
    }

    public List<TagReference> getTagReferencess() {
        return Collections.unmodifiableList(this.tags);
    }

    public List<Tag> getTags() {
        HashSet duplicates = new HashSet();
        return this.tags.stream().map(TagReference::getTag).filter(x -> x != Tag.REMOVED_TAG).filter(x -> x.isEmpty() || duplicates.add(x.getContent())).collect(Collectors.toList());
    }
}

