import { BroadcastAddress } from "../../zspec/enums";
import * as Zcl from "../../zspec/zcl";
import type { TFoundation } from "../../zspec/zcl/definition/clusters-types";
import type * as ZclTypes from "../../zspec/zcl/definition/tstype";
import type { ClusterOrRawAttributeKeys, ClusterOrRawAttributes, ClusterOrRawPayload, FoundationOrRawPayload, KeyValue, PartialClusterOrRawWriteAttributes, SendPolicy, TCustomCluster } from "../tstype";
import Device from "./device";
import Group from "./group";
import { ZigbeeEntity } from "./zigbeeEntity";
export interface ConfigureReportingItem<Cl extends string | number, Custom extends TCustomCluster | undefined = undefined> {
    attribute: ClusterOrRawAttributeKeys<Cl, Custom>[number] | {
        ID: number;
        type: number;
    };
    minimumReportInterval: number;
    maximumReportInterval: number;
    reportableChange: number;
}
interface Options {
    manufacturerCode?: number;
    disableDefaultResponse?: boolean;
    disableResponse?: boolean;
    timeout?: number;
    direction?: Zcl.Direction;
    srcEndpoint?: number;
    reservedBits?: number;
    transactionSequenceNumber?: number;
    disableRecovery?: boolean;
    writeUndiv?: boolean;
    sendPolicy?: SendPolicy;
}
interface Clusters {
    [cluster: string]: {
        attributes: {
            [attribute: string]: number | string;
        };
    };
}
interface Bind {
    cluster: ZclTypes.Cluster;
    target: Endpoint | Group;
}
interface ConfiguredReporting {
    cluster: ZclTypes.Cluster;
    attribute: ZclTypes.Attribute;
    minimumReportInterval: number;
    maximumReportInterval: number;
    reportableChange: number;
}
export declare class Endpoint extends ZigbeeEntity {
    deviceID?: number;
    inputClusters: number[];
    outputClusters: number[];
    profileID?: number;
    readonly ID: number;
    readonly clusters: Clusters;
    deviceIeeeAddress: string;
    deviceNetworkAddress: number;
    private _binds;
    private _configuredReportings;
    meta: KeyValue;
    private pendingRequests;
    get binds(): Bind[];
    get configuredReportings(): ConfiguredReporting[];
    private constructor();
    /**
     * Get device of this endpoint
     */
    getDevice(): Device;
    /**
     * @param {number|string} clusterKey
     * @returns {boolean}
     */
    supportsInputCluster(clusterKey: number | string): boolean;
    /**
     * @param {number|string} clusterKey
     * @returns {boolean}
     */
    supportsOutputCluster(clusterKey: number | string): boolean;
    /**
     * @returns {ZclTypes.Cluster[]}
     */
    getInputClusters(): ZclTypes.Cluster[];
    /**
     * @returns {ZclTypes.Cluster[]}
     */
    getOutputClusters(): ZclTypes.Cluster[];
    private clusterNumbersToClusters;
    static fromDatabaseRecord(record: KeyValue, deviceNetworkAddress: number, deviceIeeeAddress: string): Endpoint;
    toDatabaseRecord(): KeyValue;
    static create(id: number, profileID: number | undefined, deviceID: number | undefined, inputClusters: number[], outputClusters: number[], deviceNetworkAddress: number, deviceIeeeAddress: string): Endpoint;
    saveClusterAttributeKeyValue(clusterKey: number | string, list: KeyValue): void;
    getClusterAttributeValue(clusterKey: number | string, attributeKey: number | string): number | string | undefined;
    hasPendingRequests(): boolean;
    sendPendingRequests(fastPolling: boolean): Promise<void>;
    private sendRequest;
    private checkStatus;
    report<Cl extends number | string, Custom extends TCustomCluster | undefined = undefined>(clusterKey: Cl, attributes: PartialClusterOrRawWriteAttributes<Cl, Custom>, options?: Options): Promise<void>;
    write<Cl extends number | string, Custom extends TCustomCluster | undefined = undefined>(clusterKey: Cl, attributes: PartialClusterOrRawWriteAttributes<Cl, Custom>, options?: Options): Promise<void>;
    writeResponse<Cl extends number | string, Custom extends TCustomCluster | undefined = undefined>(clusterKey: Cl, transactionSequenceNumber: number, attributes: Partial<Record<ClusterOrRawAttributeKeys<Cl, Custom>[number], TFoundation["writeRsp"][number]>> & Record<number, TFoundation["writeRsp"][number]>, options?: Options): Promise<void>;
    read<Cl extends number | string, Custom extends TCustomCluster | undefined = undefined>(clusterKey: Cl, attributes: ClusterOrRawAttributeKeys<Cl, Custom>, options?: Options): Promise<ClusterOrRawAttributes<Cl, Custom>>;
    readResponse<Cl extends number | string, Custom extends TCustomCluster | undefined = undefined>(clusterKey: Cl, transactionSequenceNumber: number, attributes: PartialClusterOrRawWriteAttributes<Cl, Custom>, options?: Options): Promise<void>;
    updateSimpleDescriptor(): Promise<void>;
    hasBind(clusterId: number, target: Endpoint | Group): boolean;
    getBindIndex(clusterId: number, target: Endpoint | Group): number;
    addBinding(clusterKey: number | string, target: Endpoint | Group | number): void;
    private addBindingInternal;
    bind(clusterKey: number | string, target: Endpoint | Group | number): Promise<void>;
    save(): void;
    unbind(clusterKey: number | string, target: Endpoint | Group | number): Promise<void>;
    defaultResponse(commandID: number, status: number, clusterID: number, transactionSequenceNumber: number, options?: Options): Promise<void>;
    configureReporting<Cl extends number | string, Custom extends TCustomCluster | undefined = undefined>(clusterKey: Cl, items: ConfigureReportingItem<Cl, Custom>[], options?: Options): Promise<void>;
    writeStructured<Cl extends number | string>(clusterKey: Cl, payload: TFoundation["writeStructured"], options?: Options): Promise<void>;
    command<Cl extends number | string, Co extends number | string, Custom extends TCustomCluster | undefined = undefined>(clusterKey: Cl, commandKey: Co, payload: ClusterOrRawPayload<Cl, Co, Custom>, options?: Options): Promise<undefined | KeyValue>;
    commandResponse<Cl extends number | string, Co extends number | string, Custom extends TCustomCluster | undefined = undefined>(clusterKey: Cl, commandKey: Co, payload: ClusterOrRawPayload<Cl, Co, Custom>, options?: Options, transactionSequenceNumber?: number): Promise<void>;
    waitForCommand(clusterKey: number | string, commandKey: number | string, transactionSequenceNumber: number | undefined, timeout: number): {
        promise: Promise<{
            header: Zcl.Header;
            payload: KeyValue;
        }>;
        cancel: () => void;
    };
    private getOptionsWithDefaults;
    private ensureManufacturerCodeIsUniqueAndGet;
    addToGroup(group: Group): Promise<void>;
    private getCluster;
    /**
     * Remove endpoint from a group, accepts both a Group and number as parameter.
     * The number parameter type should only be used when removing from a group which is not known
     * to zigbee-herdsman.
     */
    removeFromGroup(group: Group | number): Promise<void>;
    removeFromAllGroups(): Promise<void>;
    removeFromAllGroupsDatabase(): void;
    zclCommand<Cl extends number | string, Co extends number | string, Custom extends TCustomCluster | undefined = undefined>(clusterKey: Cl | ZclTypes.Cluster, commandKey: Co | ZclTypes.Command, payload: ClusterOrRawPayload<Cl, Co, Custom> | FoundationOrRawPayload<Co>, options?: Options, logPayload?: KeyValue, checkStatus?: boolean, frameType?: Zcl.FrameType): Promise<undefined | Zcl.Frame>;
    zclCommandBroadcast<Cl extends number | string, Co extends number | string, Custom extends TCustomCluster | undefined = undefined>(endpoint: number, destination: BroadcastAddress, clusterKey: Cl, commandKey: Co, payload: ClusterOrRawPayload<Cl, Co, Custom> | FoundationOrRawPayload<Co>, options?: Options): Promise<void>;
}
export default Endpoint;
//# sourceMappingURL=endpoint.d.ts.map