import events from "node:events";
import type * as Models from "../models";
import type { BroadcastAddress } from "../zspec/enums";
import * as Zcl from "../zspec/zcl";
import type * as Zdo from "../zspec/zdo";
import type * as ZdoTypes from "../zspec/zdo/definition/tstypes";
import type * as AdapterEvents from "./events";
import type * as TsType from "./tstype";
interface AdapterEventMap {
    deviceJoined: [payload: AdapterEvents.DeviceJoinedPayload];
    zclPayload: [payload: AdapterEvents.ZclPayload];
    zdoResponse: [clusterId: Zdo.ClusterId, response: ZdoTypes.GenericZdoResponse];
    disconnected: [];
    deviceLeave: [payload: AdapterEvents.DeviceLeavePayload];
}
export declare abstract class Adapter extends events.EventEmitter<AdapterEventMap> {
    hasZdoMessageOverhead: boolean;
    manufacturerID: Zcl.ManufacturerCode;
    protected networkOptions: TsType.NetworkOptions;
    protected adapterOptions: TsType.AdapterOptions;
    protected serialPortOptions: TsType.SerialPortOptions;
    protected backupPath: string;
    protected constructor(networkOptions: TsType.NetworkOptions, serialPortOptions: TsType.SerialPortOptions, backupPath: string, adapterOptions: TsType.AdapterOptions);
    /**
     * Utility
     */
    static create(networkOptions: TsType.NetworkOptions, serialPortOptions: TsType.SerialPortOptions, backupPath: string, adapterOptions: TsType.AdapterOptions): Promise<Adapter>;
    abstract start(): Promise<TsType.StartResult>;
    abstract stop(): Promise<void>;
    abstract getCoordinatorIEEE(): Promise<string>;
    abstract getCoordinatorVersion(): Promise<TsType.CoordinatorVersion>;
    abstract reset(type: "soft" | "hard"): Promise<void>;
    abstract supportsBackup(): Promise<boolean>;
    abstract backup(ieeeAddressesInDatabase: string[]): Promise<Models.Backup>;
    abstract getNetworkParameters(): Promise<TsType.NetworkParameters>;
    abstract addInstallCode(ieeeAddress: string, key: Buffer, hashed: boolean): Promise<void>;
    abstract waitFor(networkAddress: number | undefined, endpoint: number, frameType: Zcl.FrameType, direction: Zcl.Direction, transactionSequenceNumber: number | undefined, clusterID: number, commandIdentifier: number, timeout: number): {
        promise: Promise<AdapterEvents.ZclPayload>;
        cancel: () => void;
    };
    /**
     * ZDO
     */
    abstract sendZdo(ieeeAddress: string, networkAddress: number, clusterId: Zdo.ClusterId, payload: Buffer, disableResponse: true): Promise<void>;
    abstract sendZdo<K extends keyof ZdoTypes.RequestToResponseMap>(ieeeAddress: string, networkAddress: number, clusterId: K, payload: Buffer, disableResponse: false): Promise<ZdoTypes.RequestToResponseMap[K]>;
    abstract sendZdo<K extends keyof ZdoTypes.RequestToResponseMap>(ieeeAddress: string, networkAddress: number, clusterId: K, payload: Buffer, disableResponse: boolean): Promise<ZdoTypes.RequestToResponseMap[K] | undefined>;
    abstract permitJoin(seconds: number, networkAddress?: number): Promise<void>;
    /**
     * ZCL
     */
    abstract sendZclFrameToEndpoint(ieeeAddr: string, networkAddress: number, endpoint: number, zclFrame: Zcl.Frame, timeout: number, disableResponse: boolean, disableRecovery: boolean, sourceEndpoint?: number): Promise<AdapterEvents.ZclPayload | undefined>;
    abstract sendZclFrameToGroup(groupID: number, zclFrame: Zcl.Frame, sourceEndpoint?: number): Promise<void>;
    abstract sendZclFrameToAll(endpoint: number, zclFrame: Zcl.Frame, sourceEndpoint: number, destination: BroadcastAddress): Promise<void>;
    /**
     * InterPAN
     */
    abstract setChannelInterPAN(channel: number): Promise<void>;
    abstract sendZclFrameInterPANToIeeeAddr(zclFrame: Zcl.Frame, ieeeAddress: string): Promise<void>;
    abstract sendZclFrameInterPANBroadcast(zclFrame: Zcl.Frame, timeout: number): Promise<AdapterEvents.ZclPayload>;
    abstract restoreChannelInterPAN(): Promise<void>;
}
export default Adapter;
//# sourceMappingURL=adapter.d.ts.map