/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram.command;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.timingdiagram.TimingDiagram;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandScalePixel
extends SingleLineCommand2<TimingDiagram> {
    public CommandScalePixel() {
        super(CommandScalePixel.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandScalePixel.class.getName(), RegexLeaf.start(), new RegexLeaf("scale"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "TICK", "(\\d+)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "PIXEL", "(\\d+)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("pixels?"), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
    }

    @Override
    protected final CommandExecutionResult executeArg(TimingDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) {
        long tick = Long.parseLong(arg.get("TICK", 0));
        long pixel = Long.parseLong(arg.get("PIXEL", 0));
        if (tick <= 0L || pixel <= 0L) {
            return CommandExecutionResult.error("Bad value");
        }
        diagram.scaleInPixels(tick, pixel);
        return CommandExecutionResult.ok();
    }
}

