import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { TestFunctionRequestFilterSensitiveLog, TestFunctionResultFilterSensitiveLog, } from "../models/models_2";
import { de_TestFunctionCommand, se_TestFunctionCommand } from "../protocols/Aws_restXml";
export { $Command };
export class TestFunctionCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("Cloudfront2020_05_31", "TestFunction", {})
    .n("CloudFrontClient", "TestFunctionCommand")
    .f(TestFunctionRequestFilterSensitiveLog, TestFunctionResultFilterSensitiveLog)
    .ser(se_TestFunctionCommand)
    .de(de_TestFunctionCommand)
    .build() {
}
