/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ResourceStat;
import org.opensearch.client.opensearch._types.ThreadInfo;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ResourceStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ResourceStats> {
    @Nonnull
    private final ResourceStat average;
    @Nonnull
    private final ResourceStat max;
    @Nonnull
    private final ResourceStat min;
    @Nonnull
    private final ThreadInfo threadInfo;
    @Nonnull
    private final ResourceStat total;
    public static final JsonpDeserializer<ResourceStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ResourceStats::setupResourceStatsDeserializer);

    private ResourceStats(Builder builder) {
        this.average = ApiTypeHelper.requireNonNull(builder.average, this, "average");
        this.max = ApiTypeHelper.requireNonNull(builder.max, this, "max");
        this.min = ApiTypeHelper.requireNonNull(builder.min, this, "min");
        this.threadInfo = ApiTypeHelper.requireNonNull(builder.threadInfo, this, "threadInfo");
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
    }

    public static ResourceStats of(Function<Builder, ObjectBuilder<ResourceStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final ResourceStat average() {
        return this.average;
    }

    @Nonnull
    public final ResourceStat max() {
        return this.max;
    }

    @Nonnull
    public final ResourceStat min() {
        return this.min;
    }

    @Nonnull
    public final ThreadInfo threadInfo() {
        return this.threadInfo;
    }

    @Nonnull
    public final ResourceStat total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("average");
        this.average.serialize(generator, mapper);
        generator.writeKey("max");
        this.max.serialize(generator, mapper);
        generator.writeKey("min");
        this.min.serialize(generator, mapper);
        generator.writeKey("thread_info");
        this.threadInfo.serialize(generator, mapper);
        generator.writeKey("total");
        this.total.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupResourceStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::average, ResourceStat._DESERIALIZER, "average");
        op.add(Builder::max, ResourceStat._DESERIALIZER, "max");
        op.add(Builder::min, ResourceStat._DESERIALIZER, "min");
        op.add(Builder::threadInfo, ThreadInfo._DESERIALIZER, "thread_info");
        op.add(Builder::total, ResourceStat._DESERIALIZER, "total");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.average.hashCode();
        result = 31 * result + this.max.hashCode();
        result = 31 * result + this.min.hashCode();
        result = 31 * result + this.threadInfo.hashCode();
        result = 31 * result + this.total.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceStats other = (ResourceStats)o;
        return this.average.equals(other.average) && this.max.equals(other.max) && this.min.equals(other.min) && this.threadInfo.equals(other.threadInfo) && this.total.equals(other.total);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ResourceStats> {
        private ResourceStat average;
        private ResourceStat max;
        private ResourceStat min;
        private ThreadInfo threadInfo;
        private ResourceStat total;

        public Builder() {
        }

        private Builder(ResourceStats o) {
            this.average = o.average;
            this.max = o.max;
            this.min = o.min;
            this.threadInfo = o.threadInfo;
            this.total = o.total;
        }

        private Builder(Builder o) {
            this.average = o.average;
            this.max = o.max;
            this.min = o.min;
            this.threadInfo = o.threadInfo;
            this.total = o.total;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder average(ResourceStat value) {
            this.average = value;
            return this;
        }

        @Nonnull
        public final Builder average(Function<ResourceStat.Builder, ObjectBuilder<ResourceStat>> fn) {
            return this.average(fn.apply(new ResourceStat.Builder()).build());
        }

        @Nonnull
        public final Builder max(ResourceStat value) {
            this.max = value;
            return this;
        }

        @Nonnull
        public final Builder max(Function<ResourceStat.Builder, ObjectBuilder<ResourceStat>> fn) {
            return this.max(fn.apply(new ResourceStat.Builder()).build());
        }

        @Nonnull
        public final Builder min(ResourceStat value) {
            this.min = value;
            return this;
        }

        @Nonnull
        public final Builder min(Function<ResourceStat.Builder, ObjectBuilder<ResourceStat>> fn) {
            return this.min(fn.apply(new ResourceStat.Builder()).build());
        }

        @Nonnull
        public final Builder threadInfo(ThreadInfo value) {
            this.threadInfo = value;
            return this;
        }

        @Nonnull
        public final Builder threadInfo(Function<ThreadInfo.Builder, ObjectBuilder<ThreadInfo>> fn) {
            return this.threadInfo(fn.apply(new ThreadInfo.Builder()).build());
        }

        @Nonnull
        public final Builder total(ResourceStat value) {
            this.total = value;
            return this;
        }

        @Nonnull
        public final Builder total(Function<ResourceStat.Builder, ObjectBuilder<ResourceStat>> fn) {
            return this.total(fn.apply(new ResourceStat.Builder()).build());
        }

        @Override
        @Nonnull
        public ResourceStats build() {
            this._checkSingleUse();
            return new ResourceStats(this);
        }
    }
}

