/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.response.search;

import java.io.IOException;
import org.apache.lucene.search.TotalHits;
import org.opensearch.protobufs.Hit;
import org.opensearch.protobufs.HitsMetadata;
import org.opensearch.protobufs.NullValue;
import org.opensearch.protobufs.TotalHits;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.transport.grpc.proto.response.search.SearchHitProtoUtils;

public class SearchHitsProtoUtils {
    private SearchHitsProtoUtils() {
    }

    protected static HitsMetadata toProto(SearchHits hits) throws IOException {
        HitsMetadata.Builder hitsMetaData = HitsMetadata.newBuilder();
        SearchHitsProtoUtils.toProto(hits, hitsMetaData);
        return hitsMetaData.build();
    }

    protected static void toProto(SearchHits hits, HitsMetadata.Builder hitsMetaData) throws IOException {
        SearchHitsProtoUtils.processTotalHits(hits, hitsMetaData);
        SearchHitsProtoUtils.processMaxScore(hits, hitsMetaData);
        SearchHitsProtoUtils.processHits(hits, hitsMetaData);
    }

    private static void processTotalHits(SearchHits hits, HitsMetadata.Builder hitsMetaData) {
        HitsMetadata.Total.Builder totalBuilder = HitsMetadata.Total.newBuilder();
        boolean totalHitAsInt = false;
        if (totalHitAsInt) {
            long total = hits.getTotalHits() == null ? -1L : hits.getTotalHits().value();
            totalBuilder.setDoubleValue((double)total);
        } else if (hits.getTotalHits() != null) {
            TotalHits.Builder totalHitsBuilder = TotalHits.newBuilder();
            totalHitsBuilder.setValue(hits.getTotalHits().value());
            TotalHits.TotalHitsRelation relation = hits.getTotalHits().relation() == TotalHits.Relation.EQUAL_TO ? TotalHits.TotalHitsRelation.TOTAL_HITS_RELATION_EQ : TotalHits.TotalHitsRelation.TOTAL_HITS_RELATION_GTE;
            totalHitsBuilder.setRelation(relation);
            totalBuilder.setTotalHits(totalHitsBuilder.build());
        }
        hitsMetaData.setTotal(totalBuilder.build());
    }

    private static void processMaxScore(SearchHits hits, HitsMetadata.Builder hitsMetaData) {
        HitsMetadata.MaxScore.Builder maxScoreBuilder = HitsMetadata.MaxScore.newBuilder();
        if (Float.isNaN(hits.getMaxScore())) {
            maxScoreBuilder.setNullValue(NullValue.NULL_VALUE_NULL);
        } else {
            maxScoreBuilder.setFloatValue(hits.getMaxScore());
        }
        hitsMetaData.setMaxScore(maxScoreBuilder.build());
    }

    private static void processHits(SearchHits hits, HitsMetadata.Builder hitsMetaData) throws IOException {
        for (SearchHit hit : hits) {
            Hit.Builder hitBuilder = Hit.newBuilder();
            SearchHitProtoUtils.toProto(hit, hitBuilder);
            hitsMetaData.addHits(hitBuilder.build());
        }
    }
}

