/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import org.opensearch.rule.attribute_extractor.AttributeExtractor;
import org.opensearch.rule.autotagging.Attribute;
import org.opensearch.rule.autotagging.Rule;
import org.opensearch.rule.storage.AttributeValueStore;
import org.opensearch.rule.storage.AttributeValueStoreFactory;

public class InMemoryRuleProcessingService {
    public static final String WILDCARD = "*";
    private final AttributeValueStoreFactory attributeValueStoreFactory;

    public InMemoryRuleProcessingService(AttributeValueStoreFactory attributeValueStoreFactory) {
        this.attributeValueStoreFactory = attributeValueStoreFactory;
    }

    public void add(Rule rule) {
        this.perform(rule, this::addOperation);
    }

    public void remove(Rule rule) {
        this.perform(rule, this::removeOperation);
    }

    private void perform(Rule rule, BiConsumer<Map.Entry<Attribute, Set<String>>, Rule> ruleOperation) {
        for (Map.Entry attributeEntry : rule.getAttributeMap().entrySet()) {
            ruleOperation.accept(attributeEntry, rule);
        }
    }

    private void removeOperation(Map.Entry<Attribute, Set<String>> attributeEntry, Rule rule) {
        AttributeValueStore valueStore = this.attributeValueStoreFactory.getAttributeValueStore(attributeEntry.getKey());
        for (String value : attributeEntry.getValue()) {
            valueStore.remove((Object)value.replace(WILDCARD, ""));
        }
    }

    private void addOperation(Map.Entry<Attribute, Set<String>> attributeEntry, Rule rule) {
        AttributeValueStore valueStore = this.attributeValueStoreFactory.getAttributeValueStore(attributeEntry.getKey());
        for (String value : attributeEntry.getValue()) {
            valueStore.put((Object)value.replace(WILDCARD, ""), (Object)rule.getFeatureValue());
        }
    }

    public Optional<String> evaluateLabel(List<AttributeExtractor<String>> attributeExtractors) {
        assert (this.attributeValueStoreFactory != null);
        Optional result = Optional.empty();
        for (AttributeExtractor<String> attributeExtractor : attributeExtractors) {
            AttributeValueStore valueStore = this.attributeValueStoreFactory.getAttributeValueStore(attributeExtractor.getAttribute());
            for (String value : attributeExtractor.extract()) {
                Optional possibleMatch = valueStore.get((Object)value);
                if (possibleMatch.isEmpty()) {
                    return Optional.empty();
                }
                if (result.isEmpty()) {
                    result = possibleMatch;
                    continue;
                }
                boolean isThePossibleMatchEqualResult = ((String)possibleMatch.get()).equals(result.get());
                if (isThePossibleMatchEqualResult) continue;
                return Optional.empty();
            }
        }
        return result;
    }
}

