/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.websvc.saas.codegen.SaasClientCodeGenerationManager;
import org.netbeans.modules.websvc.saas.codegen.SaasClientCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.model.RestClientSaasBean;
import org.netbeans.modules.websvc.saas.codegen.ui.ProgressDialog;
import org.netbeans.modules.websvc.saas.codegen.util.Util;
import org.netbeans.modules.websvc.saas.model.SaasMethod;
import org.netbeans.modules.websvc.saas.model.WadlSaasMethod;
import org.netbeans.modules.websvc.saas.model.wadl.Method;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.ActiveEditorDrop;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RestClientEditorDrop
implements ActiveEditorDrop {
    private WadlSaasMethod method;
    private FileObject targetFO;
    private RequestProcessor.Task generatorTask;

    public RestClientEditorDrop(WadlSaasMethod method) {
        this.method = method;
    }

    public boolean handleTransfer(JTextComponent targetComponent) {
        if (SaasClientCodeGenerationManager.canAccept((SaasMethod)this.method, targetComponent.getDocument())) {
            return this.doHandleTransfer(targetComponent);
        }
        return false;
    }

    private boolean doHandleTransfer(final JTextComponent targetComponent) {
        final Document targetDoc = targetComponent.getDocument();
        final FileObject targetSource = NbEditorUtilities.getFileObject((Document)targetDoc);
        Project targetProject = FileOwnerQuery.getOwner((FileObject)targetSource);
        Method m = this.method.getWadlMethod();
        if (m == null) {
            Exceptions.printStackTrace((Throwable)new IOException("Wadl method not found"));
        }
        final String displayName = m.getName();
        this.targetFO = RestClientEditorDrop.getTargetFile(targetDoc);
        if (this.targetFO == null) {
            return false;
        }
        final ArrayList errors = new ArrayList();
        final ProgressDialog dialog = new ProgressDialog(NbBundle.getMessage(RestClientEditorDrop.class, (String)"LBL_CodeGenProgress", (Object)displayName));
        this.generatorTask = RequestProcessor.getDefault().create(new Runnable(){
            final /* synthetic */ RestClientEditorDrop this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SaasClientCodeGenerator codegen = (SaasClientCodeGenerator)SaasClientCodeGenerationManager.lookup((SaasMethod)this.this$0.method, targetDoc);
                    codegen.init((SaasMethod)this.this$0.method, targetDoc);
                    codegen.setDropLocation(targetComponent);
                    RestClientSaasBean bean = (RestClientSaasBean)codegen.getBean();
                    List<ParameterInfo> allParams = bean.filterParametersByAuth(bean.filterParameters(new ParameterInfo.ParamFilter[]{ParameterInfo.ParamFilter.FIXED}));
                    boolean response = Util.showDialog(displayName, allParams, targetDoc);
                    if (response) {
                        Util.doGenerateCode(codegen, dialog, errors);
                    }
                }
                catch (Exception ioe) {
                    if ("WARN_UnsupportedDropTarget".equals(ioe.getMessage())) {
                        Util.showUnsupportedDropMessage(new Object[]{targetSource.getNameExt(), "Java Client"});
                        return;
                    }
                    errors.add(ioe);
                }
                finally {
                    dialog.close();
                }
            }
        });
        this.generatorTask.schedule(50);
        dialog.open();
        if (errors.size() > 0) {
            Exceptions.printStackTrace((Throwable)((Throwable)errors.get(0)));
            return false;
        }
        return true;
    }

    public static FileObject getTargetFile(Document doc) {
        if (doc == null) {
            return null;
        }
        DataObject d = NbEditorUtilities.getDataObject((Document)doc);
        if (d == null) {
            return null;
        }
        EditorCookie ec = (EditorCookie)d.getCookie(EditorCookie.class);
        if (ec == null || ec.getOpenedPanes() == null) {
            return null;
        }
        return d.getPrimaryFile();
    }
}

