/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project;

import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Utilities;

public final class ModuleDependency
implements Comparable<ModuleDependency> {
    private String releaseVersion;
    private String specVersion;
    private static final String SPEC_VERSION_LAZY = "<lazy>";
    private boolean implDep;
    private boolean compileDep;
    boolean buildPrerequisite;
    boolean runDependency;
    private ModuleEntry me;
    private Set<String> filterTokensNotFriend;
    private Set<String> filterTokensFriend;
    public static final Comparator<ModuleDependency> LOCALIZED_NAME_COMPARATOR = new Comparator<ModuleDependency>(){

        @Override
        public int compare(ModuleDependency d1, ModuleDependency d2) {
            ModuleEntry me1 = d1.getModuleEntry();
            ModuleEntry me2 = d2.getModuleEntry();
            int result = Collator.getInstance().compare(me1.getLocalizedName(), me2.getLocalizedName());
            return result != 0 ? result : me1.getCodeNameBase().compareTo(me2.getCodeNameBase());
        }
    };
    public static final Comparator<ModuleDependency> CNB_COMPARATOR = new Comparator<ModuleDependency>(){

        @Override
        public int compare(ModuleDependency d1, ModuleDependency d2) {
            return d1.getCodeNameBase().compareTo(d2.getCodeNameBase());
        }
    };

    public ModuleDependency(ModuleEntry me) {
        this(me, me.getReleaseVersion(), SPEC_VERSION_LAZY, me.getPublicPackages().length > 0, false);
    }

    public ModuleDependency(ModuleEntry me, String releaseVersion, String specVersion, boolean compileDep, boolean implDep) throws NumberFormatException {
        this.me = me;
        this.compileDep = compileDep;
        this.implDep = implDep;
        this.releaseVersion = releaseVersion;
        if (specVersion != null && !specVersion.equals(SPEC_VERSION_LAZY)) {
            new SpecificationVersion(specVersion);
        }
        this.specVersion = specVersion;
        this.buildPrerequisite = compileDep;
        this.runDependency = true;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public String getSpecificationVersion() {
        if (SPEC_VERSION_LAZY.equals(this.specVersion)) {
            this.specVersion = this.me.getSpecificationVersion();
        }
        return this.specVersion;
    }

    public ModuleEntry getModuleEntry() {
        return this.me;
    }

    private String getCodeNameBase() {
        return this.getModuleEntry().getCodeNameBase();
    }

    @Override
    public int compareTo(ModuleDependency other) {
        int result = this.getCodeNameBase().compareTo(other.getCodeNameBase());
        if (result != 0) {
            return result;
        }
        String relVersion = other.getReleaseVersion();
        int n = this.getReleaseVersion() == null ? (relVersion == null ? 0 : -1) : (result = relVersion == null ? 1 : this.getReleaseVersion().compareTo(relVersion));
        if (result != 0) {
            return result;
        }
        if (this.specVersion != SPEC_VERSION_LAZY || other.specVersion != SPEC_VERSION_LAZY) {
            String otherSpec = other.getSpecificationVersion();
            String spec = this.getSpecificationVersion();
            int n2 = spec == null ? (otherSpec == null ? 0 : -1) : (result = otherSpec == null ? 1 : spec.compareTo(otherSpec));
            if (result != 0) {
                return result;
            }
        }
        int n3 = this.hasImplementationDependency() == other.hasImplementationDependency() ? 0 : (result = this.implDep ? 1 : -1);
        if (result != 0) {
            return result;
        }
        result = this.hasCompileDependency() == other.hasCompileDependency() ? 0 : (this.compileDep ? 1 : -1);
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof ModuleDependency) {
            ModuleDependency other = (ModuleDependency)o;
            return this.getCodeNameBase().equals(other.getCodeNameBase()) && Utilities.compareObjects((Object)this.getReleaseVersion(), (Object)other.getReleaseVersion()) && (this.specVersion == SPEC_VERSION_LAZY && other.specVersion == SPEC_VERSION_LAZY || Utilities.compareObjects((Object)this.getSpecificationVersion(), (Object)other.getSpecificationVersion())) && this.hasImplementationDependency() == other.hasImplementationDependency() && this.hasCompileDependency() == other.hasCompileDependency();
        }
        return false;
    }

    public int hashCode() {
        return this.getCodeNameBase().hashCode();
    }

    public boolean hasCompileDependency() {
        return this.compileDep;
    }

    public boolean hasImplementationDependency() {
        return this.implDep;
    }

    public Set<String> getFilterTokens(String dependingModuleCNB) {
        Set<String> filterTokens;
        boolean friend = this.me.isDeclaredAsFriend(dependingModuleCNB);
        Set<String> set = filterTokens = friend ? this.filterTokensFriend : this.filterTokensNotFriend;
        if (filterTokens == null) {
            filterTokens = new HashSet<String>();
            filterTokens.add(this.me.getCodeNameBase());
            filterTokens.add(this.me.getLocalizedName());
            filterTokens.add(this.me.getJarLocation().getAbsolutePath());
            String[] cpext = PropertyUtils.tokenizePath((String)this.me.getClassPathExtensions());
            filterTokens.addAll(Arrays.asList(cpext));
            if (friend) {
                for (String clazz : this.me.getPublicClassNames()) {
                    filterTokens.add(clazz.replace('$', '.'));
                }
            }
            if (friend) {
                this.filterTokensFriend = filterTokens;
            } else {
                this.filterTokensNotFriend = filterTokens;
            }
        }
        return filterTokens;
    }

    public String toString() {
        return "ModuleDependency[me: " + String.valueOf(this.getModuleEntry()) + ", relVer: " + this.getReleaseVersion() + ", specVer: " + this.getSpecificationVersion() + ", implDep: " + this.hasImplementationDependency() + ", compDep: " + this.hasCompileDependency() + "]";
    }
}

