/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.netbeans.modules.versioning.util.VCSOptionsKeywordsProvider;
import org.netbeans.modules.versioning.util.VcsAdvancedOptionsPanel;
import org.netbeans.spi.options.AdvancedOption;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class VcsAdvancedOptions
extends OptionsPanelController {
    public static final String ID = "Versioning";
    private VcsAdvancedOptionsPanel panel;
    private boolean initialized = false;
    private final Map<String, OptionsPanelController> categoryToController = new HashMap<String, OptionsPanelController>();

    private void init(Lookup masterLookup) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.panel = new VcsAdvancedOptionsPanel();
        Lookup lookup = Lookups.forPath((String)"VersioningOptionsDialog");
        for (AdvancedOption option : lookup.lookup(new Lookup.Template(AdvancedOption.class)).allInstances()) {
            this.registerOption(option, masterLookup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerOption(AdvancedOption option, Lookup masterLookup) {
        String category = option.getDisplayName();
        OptionsPanelController controller = option.create();
        Map<String, OptionsPanelController> map = this.categoryToController;
        synchronized (map) {
            this.categoryToController.put(category, controller);
        }
        this.panel.addPanel(category, controller.getComponent(masterLookup));
        if ("org.netbeans.modules.versioning.ui.options.GeneralAdvancedOption".equals(option.getClass().getName())) {
            this.panel.addPanel(category, controller.getComponent(masterLookup));
        }
    }

    public JComponent getComponent(Lookup masterLookup) {
        this.init(masterLookup);
        return this.panel;
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void update() {
        for (OptionsPanelController c : this.getControllers()) {
            c.update();
        }
    }

    public void applyChanges() {
        for (OptionsPanelController c : this.getControllers()) {
            c.applyChanges();
        }
    }

    public void cancel() {
        for (OptionsPanelController c : this.getControllers()) {
            c.cancel();
        }
    }

    public boolean isValid() {
        for (OptionsPanelController c : this.getControllers()) {
            if (c.isValid()) continue;
            return false;
        }
        return true;
    }

    public boolean isChanged() {
        for (OptionsPanelController c : this.getControllers()) {
            if (!c.isChanged()) continue;
            return true;
        }
        return false;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.versioning.util.VcsAdvancedOptions");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSuccessfulSearch(String searchText, List<String> matchedKeywords) {
        HashMap<String, OptionsPanelController> m;
        Map<String, OptionsPanelController> map = this.categoryToController;
        synchronized (map) {
            m = new HashMap<String, OptionsPanelController>(this.categoryToController);
        }
        for (Map.Entry entry : m.entrySet()) {
            OptionsPanelController c = (OptionsPanelController)entry.getValue();
            if (!(c instanceof VCSOptionsKeywordsProvider) || !((VCSOptionsKeywordsProvider)c).acceptKeywords(matchedKeywords)) continue;
            this.panel.selectCategory((String)entry.getKey());
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCurrentSubcategory(String subpath) {
        HashMap<String, OptionsPanelController> m;
        Map<String, OptionsPanelController> map = this.categoryToController;
        synchronized (map) {
            m = new HashMap<String, OptionsPanelController>(this.categoryToController);
        }
        for (Map.Entry entry : m.entrySet()) {
            if (!((String)entry.getKey()).equals(subpath)) continue;
            this.panel.selectCategory((String)entry.getKey());
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OptionsPanelController[] getControllers() {
        Map<String, OptionsPanelController> map = this.categoryToController;
        synchronized (map) {
            return this.categoryToController.values().toArray(new OptionsPanelController[this.categoryToController.values().size()]);
        }
    }
}

