/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.debugger.debuggingview;

import javax.swing.Action;
import org.netbeans.modules.lsp.client.debugger.DAPDebugger;
import org.netbeans.modules.lsp.client.debugger.DAPFrame;
import org.netbeans.modules.lsp.client.debugger.DAPStackTraceAnnotationHolder;
import org.netbeans.modules.lsp.client.debugger.DAPThread;
import org.netbeans.modules.lsp.client.debugger.debuggingview.Bundle;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.text.Annotatable;
import org.openide.text.Line;
import org.openide.util.RequestProcessor;

public class DebuggingActionsProvider
implements NodeActionsProvider {
    private final DAPDebugger debugger;
    private final RequestProcessor requestProcessor = new RequestProcessor("Debugging View Actions", 1);
    private final Action MAKE_CURRENT_ACTION;
    private final Action GO_TO_SOURCE_ACTION;

    public DebuggingActionsProvider(ContextProvider lookupProvider) {
        this.debugger = (DAPDebugger)lookupProvider.lookupFirst(null, DAPDebugger.class);
        this.MAKE_CURRENT_ACTION = this.createMAKE_CURRENT_ACTION(this.requestProcessor);
        this.GO_TO_SOURCE_ACTION = DebuggingActionsProvider.createGO_TO_SOURCE_ACTION(this.requestProcessor);
    }

    private Action createMAKE_CURRENT_ACTION(RequestProcessor requestProcessor) {
        return Models.createAction((String)Bundle.CTL_ThreadAction_MakeCurrent_Label(), (Models.ActionPerformer)new LazyActionPerformer(requestProcessor){

            @Override
            public boolean isEnabled(Object node) {
                if (node instanceof DAPThread) {
                    return DebuggingActionsProvider.this.debugger.getCurrentThread() != node;
                }
                if (node instanceof DAPFrame) {
                    DAPFrame frame = (DAPFrame)node;
                    return !frame.equals(DebuggingActionsProvider.this.debugger.getCurrentFrame());
                }
                return false;
            }

            @Override
            public void run(Object[] nodes) {
                if (nodes.length == 0) {
                    return;
                }
                if (nodes[0] instanceof DAPThread) {
                    DAPThread thread = (DAPThread)nodes[0];
                    thread.makeCurrent();
                    DebuggingActionsProvider.goToSource(thread);
                }
                if (nodes[0] instanceof DAPFrame) {
                    DAPFrame frame = (DAPFrame)nodes[0];
                    frame.makeCurrent();
                    DebuggingActionsProvider.goToSource(frame);
                }
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }

    static final Action createGO_TO_SOURCE_ACTION(final RequestProcessor requestProcessor) {
        return Models.createAction((String)Bundle.CTL_ThreadAction_GoToSource_Label(), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object node) {
                if (!(node instanceof DAPFrame)) {
                    return false;
                }
                return DebuggingActionsProvider.isGoToSourceSupported((DAPFrame)node);
            }

            public void perform(final Object[] nodes) {
                requestProcessor.post(new Runnable(){
                    final /* synthetic */ 2 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        DebuggingActionsProvider.goToSource((DAPFrame)nodes[0]);
                    }
                });
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        if (node instanceof DAPThread) {
            DAPThread thread = (DAPThread)node;
            boolean suspended = thread.isSuspended();
            return new Action[]{this.MAKE_CURRENT_ACTION};
        }
        if (node instanceof DAPFrame) {
            return new Action[]{this.MAKE_CURRENT_ACTION, this.GO_TO_SOURCE_ACTION};
        }
        throw new UnknownTypeException(node);
    }

    public void performDefaultAction(final Object node) throws UnknownTypeException {
        if (node == "Root") {
            return;
        }
        if (node instanceof DAPThread || node instanceof DAPFrame) {
            this.requestProcessor.post(new Runnable(){
                final /* synthetic */ DebuggingActionsProvider this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    if (node instanceof DAPThread) {
                        ((DAPThread)node).makeCurrent();
                    } else if (node instanceof DAPFrame) {
                        DAPFrame frame = (DAPFrame)node;
                        frame.makeCurrent();
                        DebuggingActionsProvider.goToSource(frame);
                    }
                }
            });
            return;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }

    private static boolean isGoToSourceSupported(DAPFrame frame) {
        Line currentLine = frame.location();
        return currentLine != null;
    }

    private static void goToSource(DAPFrame frame) {
        Line currentLine = frame.location();
        if (currentLine != null) {
            DAPStackTraceAnnotationHolder.showLine((Annotatable[])new Line[]{currentLine});
        }
    }

    private static void goToSource(DAPThread thread) {
        DAPFrame topFrame = thread.getCurrentFrame();
        if (topFrame != null) {
            DebuggingActionsProvider.goToSource(topFrame);
        }
    }

    private static abstract class LazyActionPerformer
    implements Models.ActionPerformer {
        private RequestProcessor rp;

        public LazyActionPerformer(RequestProcessor rp) {
            this.rp = rp;
        }

        public abstract boolean isEnabled(Object var1);

        public final void perform(final Object[] nodes) {
            this.rp.post(new Runnable(){
                final /* synthetic */ LazyActionPerformer this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.run(nodes);
                }
            });
        }

        public abstract void run(Object[] var1);
    }
}

