/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.Collections;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.DeclareStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.InLineHtml;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.SuggestionRule;
import org.netbeans.modules.php.editor.verification.VerificationUtils;
import org.openide.filesystems.FileObject;

public class DeclareStrictTypesSuggestion
extends SuggestionRule {
    private static final String HINT_ID = "Declare.Strict.Types.Suggestion";

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.DeclareStrictTypesSuggestion_description();
    }

    public String getDisplayName() {
        return Bundle.DeclareStrictTypesSuggestion_displayName();
    }

    protected PhpVersion getPhpVersion(@NullAllowed FileObject fileObject) {
        return fileObject == null ? PhpVersion.getDefault() : CodeUtils.getPhpVersion(fileObject);
    }

    private boolean appliesTo(FileObject fileObject) {
        return this.getPhpVersion(fileObject).compareTo((Enum)PhpVersion.PHP_70) >= 0;
    }

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject != null && this.appliesTo(fileObject)) {
            BaseDocument doc = context.doc;
            int caretOffset = this.getCaretOffset();
            OffsetRange lineBounds = VerificationUtils.createLineBounds(caretOffset, doc);
            if (lineBounds.containsInclusive(caretOffset)) {
                FixInfo fixInfo = this.createFixInfo(doc, lineBounds, caretOffset);
                if (!fixInfo.foundOpenTag()) {
                    return;
                }
                CheckVisitor checkVisitor = new CheckVisitor();
                phpParseResult.getProgram().accept(checkVisitor);
                if (CancelSupport.getDefault().isCancelled() || checkVisitor.hasDeclareStrictTypes()) {
                    return;
                }
                List<HintFix> fixes = Collections.singletonList(this.createHintFix(doc, checkVisitor.hasInlineHtml(), fixInfo));
                this.addHint(hints, fileObject, lineBounds, fixes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FixInfo createFixInfo(BaseDocument doc, OffsetRange lineBounds, int caretOffset) {
        boolean foundOpenTag = false;
        int insertOffset = 0;
        int phpOpenTagCount = 0;
        doc.readLock();
        try {
            TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, caretOffset);
            if (ts != null) {
                ts.move(lineBounds.getStart());
                while (ts.moveNext() && ts.offset() < lineBounds.getEnd()) {
                    PHPTokenId id = (PHPTokenId)ts.token().id();
                    if (id != PHPTokenId.PHP_OPENTAG || !TokenUtilities.equals((CharSequence)ts.token().text(), (Object)"<?php")) continue;
                    foundOpenTag = true;
                    break;
                }
                if (foundOpenTag) {
                    ts.move(0);
                    while (ts.moveNext()) {
                        if (ts.token().id() != PHPTokenId.PHP_OPENTAG) continue;
                        if (insertOffset == 0 && TokenUtilities.equals((CharSequence)ts.token().text(), (Object)"<?php")) {
                            insertOffset = ts.offset() + "<?php".length();
                        }
                        ++phpOpenTagCount;
                    }
                }
            }
        }
        finally {
            doc.readUnlock();
        }
        return new FixInfo(foundOpenTag, insertOffset, phpOpenTagCount);
    }

    private HintFix createHintFix(BaseDocument doc, boolean hasInlineHtml, FixInfo fixInfo) {
        return new Fix(doc, hasInlineHtml, fixInfo);
    }

    private void addHint(List<Hint> hints, FileObject file, OffsetRange offsetRang, List<HintFix> fixes) {
        hints.add(new Hint((Rule)this, Bundle.DeclareStrictTypesSuggestion_hint_description(), file, offsetRang, fixes, 500));
    }

    private static final class FixInfo {
        private final boolean foundOpenTag;
        private final int insertOffset;
        private final int phpOpenTagCount;

        public FixInfo(boolean foundOpenTag, int firstOpenTagOffset, int phpOpenTagCount) {
            this.foundOpenTag = foundOpenTag;
            this.insertOffset = firstOpenTagOffset;
            this.phpOpenTagCount = phpOpenTagCount;
        }

        public boolean foundOpenTag() {
            return this.foundOpenTag;
        }

        public int getInsertOffset() {
            return this.insertOffset;
        }

        public int getPhpOpenTagCount() {
            return this.phpOpenTagCount;
        }
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private boolean hasDeclareStrictTypes;
        private boolean hasInlineHtml;

        private CheckVisitor() {
        }

        @Override
        public void visit(InLineHtml inLineHtml) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.hasInlineHtml = true;
            super.visit(inLineHtml);
        }

        @Override
        public void visit(DeclareStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            List<Identifier> directiveNames = node.getDirectiveNames();
            List<Expression> directiveValues = node.getDirectiveValues();
            for (int i = 0; i < directiveNames.size(); ++i) {
                Scalar scalar;
                String name = directiveNames.get(i).getName();
                if (!name.equals("strict_types")) continue;
                Expression value = directiveValues.get(i);
                if (!(value instanceof Scalar) || (scalar = (Scalar)value).getScalarType() != Scalar.Type.INT || !scalar.getStringValue().equals("1")) break;
                this.hasDeclareStrictTypes = true;
                break;
            }
        }

        public boolean hasDeclareStrictTypes() {
            return this.hasDeclareStrictTypes;
        }

        public boolean hasInlineHtml() {
            return this.hasInlineHtml;
        }
    }

    private static final class Fix
    implements HintFix {
        private final BaseDocument document;
        private final boolean hasInlineHtml;
        private final FixInfo fixInfo;

        private Fix(BaseDocument document, boolean hasInlineHtml, FixInfo fixInfo) {
            this.document = document;
            this.hasInlineHtml = hasInlineHtml;
            this.fixInfo = fixInfo;
        }

        public String getDescription() {
            return Bundle.DeclareStrictTypesFixDescription();
        }

        public void implement() throws Exception {
            String insertText;
            int insertOffset;
            EditList editList = new EditList(this.document);
            if (this.hasInlineHtml || this.fixInfo.getPhpOpenTagCount() > 1) {
                insertOffset = 0;
                insertText = "<?php declare(strict_types=1) ?>\n";
            } else {
                insertOffset = this.fixInfo.getInsertOffset();
                insertText = " declare(strict_types=1);";
            }
            editList.replace(insertOffset, 0, insertText, true, 0);
            editList.apply();
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }
}

